package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.Uri
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Media(
    mediaFileUri: Optional[Uri] = Optional.Absent,
    redactedMediaFileUri: Optional[Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.Media = {
    import Media.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.Media
      .builder()
      .optionallyWith(
        mediaFileUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.mediaFileUri)
      .optionallyWith(
        redactedMediaFileUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.redactedMediaFileUri)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.Media.ReadOnly =
    zio.aws.transcribe.model.Media.wrap(buildAwsValue())
}
object Media {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.transcribe.model.Media] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.Media =
      zio.aws.transcribe.model.Media(
        mediaFileUri.map(value => value),
        redactedMediaFileUri.map(value => value)
      )
    def mediaFileUri: Optional[Uri]
    def redactedMediaFileUri: Optional[Uri]
    def getMediaFileUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("mediaFileUri", mediaFileUri)
    def getRedactedMediaFileUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("redactedMediaFileUri", redactedMediaFileUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.Media
  ) extends zio.aws.transcribe.model.Media.ReadOnly {
    override val mediaFileUri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaFileUri())
      .map(value => zio.aws.transcribe.model.primitives.Uri(value))
    override val redactedMediaFileUri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.redactedMediaFileUri())
      .map(value => zio.aws.transcribe.model.primitives.Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.Media
  ): zio.aws.transcribe.model.Media.ReadOnly = new Wrapper(impl)
}
