package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.Uri
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MedicalTranscript(
    transcriptFileUri: Optional[Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.MedicalTranscript = {
    import MedicalTranscript.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.MedicalTranscript
      .builder()
      .optionallyWith(
        transcriptFileUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.transcriptFileUri)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.MedicalTranscript.ReadOnly =
    zio.aws.transcribe.model.MedicalTranscript.wrap(buildAwsValue())
}
object MedicalTranscript {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.MedicalTranscript
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.MedicalTranscript =
      zio.aws.transcribe.model
        .MedicalTranscript(transcriptFileUri.map(value => value))
    def transcriptFileUri: Optional[Uri]
    def getTranscriptFileUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("transcriptFileUri", transcriptFileUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.MedicalTranscript
  ) extends zio.aws.transcribe.model.MedicalTranscript.ReadOnly {
    override val transcriptFileUri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.transcriptFileUri())
      .map(value => zio.aws.transcribe.model.primitives.Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.MedicalTranscript
  ): zio.aws.transcribe.model.MedicalTranscript.ReadOnly = new Wrapper(impl)
}
