package zio.aws.transcribe.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{
  VocabularyName,
  MaxAlternatives,
  MaxSpeakers
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class MedicalTranscriptionSetting(
    showSpeakerLabels: Optional[Boolean] = Optional.Absent,
    maxSpeakerLabels: Optional[MaxSpeakers] = Optional.Absent,
    channelIdentification: Optional[Boolean] = Optional.Absent,
    showAlternatives: Optional[Boolean] = Optional.Absent,
    maxAlternatives: Optional[MaxAlternatives] = Optional.Absent,
    vocabularyName: Optional[VocabularyName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionSetting = {
    import MedicalTranscriptionSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionSetting
      .builder()
      .optionallyWith(showSpeakerLabels.map(value => value: java.lang.Boolean))(
        _.showSpeakerLabels
      )
      .optionallyWith(
        maxSpeakerLabels.map(value => MaxSpeakers.unwrap(value): Integer)
      )(_.maxSpeakerLabels)
      .optionallyWith(
        channelIdentification.map(value => value: java.lang.Boolean)
      )(_.channelIdentification)
      .optionallyWith(showAlternatives.map(value => value: java.lang.Boolean))(
        _.showAlternatives
      )
      .optionallyWith(
        maxAlternatives.map(value => MaxAlternatives.unwrap(value): Integer)
      )(_.maxAlternatives)
      .optionallyWith(
        vocabularyName.map(value =>
          VocabularyName.unwrap(value): java.lang.String
        )
      )(_.vocabularyName)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.MedicalTranscriptionSetting.ReadOnly =
    zio.aws.transcribe.model.MedicalTranscriptionSetting.wrap(buildAwsValue())
}
object MedicalTranscriptionSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.MedicalTranscriptionSetting =
      zio.aws.transcribe.model.MedicalTranscriptionSetting(
        showSpeakerLabels.map(value => value),
        maxSpeakerLabels.map(value => value),
        channelIdentification.map(value => value),
        showAlternatives.map(value => value),
        maxAlternatives.map(value => value),
        vocabularyName.map(value => value)
      )
    def showSpeakerLabels: Optional[Boolean]
    def maxSpeakerLabels: Optional[MaxSpeakers]
    def channelIdentification: Optional[Boolean]
    def showAlternatives: Optional[Boolean]
    def maxAlternatives: Optional[MaxAlternatives]
    def vocabularyName: Optional[VocabularyName]
    def getShowSpeakerLabels: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("showSpeakerLabels", showSpeakerLabels)
    def getMaxSpeakerLabels: ZIO[Any, AwsError, MaxSpeakers] =
      AwsError.unwrapOptionField("maxSpeakerLabels", maxSpeakerLabels)
    def getChannelIdentification: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("channelIdentification", channelIdentification)
    def getShowAlternatives: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("showAlternatives", showAlternatives)
    def getMaxAlternatives: ZIO[Any, AwsError, MaxAlternatives] =
      AwsError.unwrapOptionField("maxAlternatives", maxAlternatives)
    def getVocabularyName: ZIO[Any, AwsError, VocabularyName] =
      AwsError.unwrapOptionField("vocabularyName", vocabularyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionSetting
  ) extends zio.aws.transcribe.model.MedicalTranscriptionSetting.ReadOnly {
    override val showSpeakerLabels: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.showSpeakerLabels())
      .map(value => value: Boolean)
    override val maxSpeakerLabels: Optional[MaxSpeakers] = zio.aws.core.internal
      .optionalFromNullable(impl.maxSpeakerLabels())
      .map(value => zio.aws.transcribe.model.primitives.MaxSpeakers(value))
    override val channelIdentification: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelIdentification())
        .map(value => value: Boolean)
    override val showAlternatives: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.showAlternatives())
      .map(value => value: Boolean)
    override val maxAlternatives: Optional[MaxAlternatives] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxAlternatives())
        .map(value =>
          zio.aws.transcribe.model.primitives.MaxAlternatives(value)
        )
    override val vocabularyName: Optional[VocabularyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyName())
        .map(value => zio.aws.transcribe.model.primitives.VocabularyName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionSetting
  ): zio.aws.transcribe.model.MedicalTranscriptionSetting.ReadOnly =
    new Wrapper(impl)
}
