package zio.aws.transcribe.model
import scala.jdk.CollectionConverters._
sealed trait PiiEntityType {
  def unwrap: software.amazon.awssdk.services.transcribe.model.PiiEntityType
}
object PiiEntityType {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.PiiEntityType
  ): zio.aws.transcribe.model.PiiEntityType = value match {
    case software.amazon.awssdk.services.transcribe.model.PiiEntityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.PiiEntityType.BANK_ACCOUNT_NUMBER =>
      val r = BANK_ACCOUNT_NUMBER
      r
    case software.amazon.awssdk.services.transcribe.model.PiiEntityType.BANK_ROUTING =>
      val r = BANK_ROUTING
      r
    case software.amazon.awssdk.services.transcribe.model.PiiEntityType.CREDIT_DEBIT_NUMBER =>
      val r = CREDIT_DEBIT_NUMBER
      r
    case software.amazon.awssdk.services.transcribe.model.PiiEntityType.CREDIT_DEBIT_CVV =>
      val r = CREDIT_DEBIT_CVV
      r
    case software.amazon.awssdk.services.transcribe.model.PiiEntityType.CREDIT_DEBIT_EXPIRY =>
      val r = CREDIT_DEBIT_EXPIRY
      r
    case software.amazon.awssdk.services.transcribe.model.PiiEntityType.PIN =>
      val r = PIN
      r
    case software.amazon.awssdk.services.transcribe.model.PiiEntityType.EMAIL =>
      val r = EMAIL
      r
    case software.amazon.awssdk.services.transcribe.model.PiiEntityType.ADDRESS =>
      val r = ADDRESS
      r
    case software.amazon.awssdk.services.transcribe.model.PiiEntityType.NAME =>
      val r = NAME
      r
    case software.amazon.awssdk.services.transcribe.model.PiiEntityType.PHONE =>
      val r = PHONE
      r
    case software.amazon.awssdk.services.transcribe.model.PiiEntityType.SSN =>
      val r = SSN
      r
    case software.amazon.awssdk.services.transcribe.model.PiiEntityType.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribe.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.PiiEntityType =
      software.amazon.awssdk.services.transcribe.model.PiiEntityType.UNKNOWN_TO_SDK_VERSION
  }
  case object BANK_ACCOUNT_NUMBER
      extends zio.aws.transcribe.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.PiiEntityType =
      software.amazon.awssdk.services.transcribe.model.PiiEntityType.BANK_ACCOUNT_NUMBER
  }
  case object BANK_ROUTING extends zio.aws.transcribe.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.PiiEntityType =
      software.amazon.awssdk.services.transcribe.model.PiiEntityType.BANK_ROUTING
  }
  case object CREDIT_DEBIT_NUMBER
      extends zio.aws.transcribe.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.PiiEntityType =
      software.amazon.awssdk.services.transcribe.model.PiiEntityType.CREDIT_DEBIT_NUMBER
  }
  case object CREDIT_DEBIT_CVV extends zio.aws.transcribe.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.PiiEntityType =
      software.amazon.awssdk.services.transcribe.model.PiiEntityType.CREDIT_DEBIT_CVV
  }
  case object CREDIT_DEBIT_EXPIRY
      extends zio.aws.transcribe.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.PiiEntityType =
      software.amazon.awssdk.services.transcribe.model.PiiEntityType.CREDIT_DEBIT_EXPIRY
  }
  case object PIN extends zio.aws.transcribe.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.PiiEntityType =
      software.amazon.awssdk.services.transcribe.model.PiiEntityType.PIN
  }
  case object EMAIL extends zio.aws.transcribe.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.PiiEntityType =
      software.amazon.awssdk.services.transcribe.model.PiiEntityType.EMAIL
  }
  case object ADDRESS extends zio.aws.transcribe.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.PiiEntityType =
      software.amazon.awssdk.services.transcribe.model.PiiEntityType.ADDRESS
  }
  case object NAME extends zio.aws.transcribe.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.PiiEntityType =
      software.amazon.awssdk.services.transcribe.model.PiiEntityType.NAME
  }
  case object PHONE extends zio.aws.transcribe.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.PiiEntityType =
      software.amazon.awssdk.services.transcribe.model.PiiEntityType.PHONE
  }
  case object SSN extends zio.aws.transcribe.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.PiiEntityType =
      software.amazon.awssdk.services.transcribe.model.PiiEntityType.SSN
  }
  case object ALL extends zio.aws.transcribe.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.PiiEntityType =
      software.amazon.awssdk.services.transcribe.model.PiiEntityType.ALL
  }
}
