package zio.aws.transcribe.model
import scala.jdk.CollectionConverters._
sealed trait Specialty {
  def unwrap: software.amazon.awssdk.services.transcribe.model.Specialty
}
object Specialty {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.Specialty
  ): zio.aws.transcribe.model.Specialty = value match {
    case software.amazon.awssdk.services.transcribe.model.Specialty.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.Specialty.PRIMARYCARE =>
      val r = PRIMARYCARE
      r
  }
  case object unknownToSdkVersion extends zio.aws.transcribe.model.Specialty {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.Specialty =
      software.amazon.awssdk.services.transcribe.model.Specialty.UNKNOWN_TO_SDK_VERSION
  }
  case object PRIMARYCARE extends zio.aws.transcribe.model.Specialty {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.Specialty =
      software.amazon.awssdk.services.transcribe.model.Specialty.PRIMARYCARE
  }
}
