package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartCallAnalyticsJobResponse(
    callAnalyticsJob: Optional[zio.aws.transcribe.model.CallAnalyticsJob] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.StartCallAnalyticsJobResponse = {
    import StartCallAnalyticsJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.StartCallAnalyticsJobResponse
      .builder()
      .optionallyWith(callAnalyticsJob.map(value => value.buildAwsValue()))(
        _.callAnalyticsJob
      )
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.StartCallAnalyticsJobResponse.ReadOnly =
    zio.aws.transcribe.model.StartCallAnalyticsJobResponse.wrap(buildAwsValue())
}
object StartCallAnalyticsJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.StartCallAnalyticsJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.StartCallAnalyticsJobResponse =
      zio.aws.transcribe.model.StartCallAnalyticsJobResponse(
        callAnalyticsJob.map(value => value.asEditable)
      )
    def callAnalyticsJob
        : Optional[zio.aws.transcribe.model.CallAnalyticsJob.ReadOnly]
    def getCallAnalyticsJob: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.CallAnalyticsJob.ReadOnly
    ] = AwsError.unwrapOptionField("callAnalyticsJob", callAnalyticsJob)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.StartCallAnalyticsJobResponse
  ) extends zio.aws.transcribe.model.StartCallAnalyticsJobResponse.ReadOnly {
    override val callAnalyticsJob
        : Optional[zio.aws.transcribe.model.CallAnalyticsJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callAnalyticsJob())
        .map(value => zio.aws.transcribe.model.CallAnalyticsJob.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.StartCallAnalyticsJobResponse
  ): zio.aws.transcribe.model.StartCallAnalyticsJobResponse.ReadOnly =
    new Wrapper(impl)
}
