package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartMedicalTranscriptionJobResponse(
    medicalTranscriptionJob: Optional[
      zio.aws.transcribe.model.MedicalTranscriptionJob
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.StartMedicalTranscriptionJobResponse = {
    import StartMedicalTranscriptionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.StartMedicalTranscriptionJobResponse
      .builder()
      .optionallyWith(
        medicalTranscriptionJob.map(value => value.buildAwsValue())
      )(_.medicalTranscriptionJob)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.StartMedicalTranscriptionJobResponse.ReadOnly =
    zio.aws.transcribe.model.StartMedicalTranscriptionJobResponse
      .wrap(buildAwsValue())
}
object StartMedicalTranscriptionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.StartMedicalTranscriptionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.transcribe.model.StartMedicalTranscriptionJobResponse =
      zio.aws.transcribe.model.StartMedicalTranscriptionJobResponse(
        medicalTranscriptionJob.map(value => value.asEditable)
      )
    def medicalTranscriptionJob
        : Optional[zio.aws.transcribe.model.MedicalTranscriptionJob.ReadOnly]
    def getMedicalTranscriptionJob: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.MedicalTranscriptionJob.ReadOnly
    ] = AwsError.unwrapOptionField(
      "medicalTranscriptionJob",
      medicalTranscriptionJob
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.StartMedicalTranscriptionJobResponse
  ) extends zio.aws.transcribe.model.StartMedicalTranscriptionJobResponse.ReadOnly {
    override val medicalTranscriptionJob
        : Optional[zio.aws.transcribe.model.MedicalTranscriptionJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.medicalTranscriptionJob())
        .map(value =>
          zio.aws.transcribe.model.MedicalTranscriptionJob.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.StartMedicalTranscriptionJobResponse
  ): zio.aws.transcribe.model.StartMedicalTranscriptionJobResponse.ReadOnly =
    new Wrapper(impl)
}
