package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.TranscribeArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: TranscribeArn,
    tags: Iterable[zio.aws.transcribe.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.TagResourceRequest
      .builder()
      .resourceArn(TranscribeArn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.TagResourceRequest.ReadOnly =
    zio.aws.transcribe.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.TagResourceRequest =
      zio.aws.transcribe.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: TranscribeArn
    def tags: List[zio.aws.transcribe.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, TranscribeArn] =
      ZIO.succeed(resourceArn)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.TagResourceRequest
  ) extends zio.aws.transcribe.model.TagResourceRequest.ReadOnly {
    override val resourceArn: TranscribeArn =
      zio.aws.transcribe.model.primitives.TranscribeArn(impl.resourceArn())
    override val tags: List[zio.aws.transcribe.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.transcribe.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.TagResourceRequest
  ): zio.aws.transcribe.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
