package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TranscriptFilter(
    transcriptFilterType: zio.aws.transcribe.model.TranscriptFilterType,
    absoluteTimeRange: Optional[zio.aws.transcribe.model.AbsoluteTimeRange] =
      Optional.Absent,
    relativeTimeRange: Optional[zio.aws.transcribe.model.RelativeTimeRange] =
      Optional.Absent,
    participantRole: Optional[zio.aws.transcribe.model.ParticipantRole] =
      Optional.Absent,
    negate: Optional[Boolean] = Optional.Absent,
    targets: Iterable[NonEmptyString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.TranscriptFilter = {
    import TranscriptFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.TranscriptFilter
      .builder()
      .transcriptFilterType(transcriptFilterType.unwrap)
      .optionallyWith(absoluteTimeRange.map(value => value.buildAwsValue()))(
        _.absoluteTimeRange
      )
      .optionallyWith(relativeTimeRange.map(value => value.buildAwsValue()))(
        _.relativeTimeRange
      )
      .optionallyWith(participantRole.map(value => value.unwrap))(
        _.participantRole
      )
      .optionallyWith(negate.map(value => value: java.lang.Boolean))(_.negate)
      .targets(targets.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.TranscriptFilter.ReadOnly =
    zio.aws.transcribe.model.TranscriptFilter.wrap(buildAwsValue())
}
object TranscriptFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.TranscriptFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.TranscriptFilter =
      zio.aws.transcribe.model.TranscriptFilter(
        transcriptFilterType,
        absoluteTimeRange.map(value => value.asEditable),
        relativeTimeRange.map(value => value.asEditable),
        participantRole.map(value => value),
        negate.map(value => value),
        targets
      )
    def transcriptFilterType: zio.aws.transcribe.model.TranscriptFilterType
    def absoluteTimeRange
        : Optional[zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly]
    def relativeTimeRange
        : Optional[zio.aws.transcribe.model.RelativeTimeRange.ReadOnly]
    def participantRole: Optional[zio.aws.transcribe.model.ParticipantRole]
    def negate: Optional[Boolean]
    def targets: List[NonEmptyString]
    def getTranscriptFilterType
        : ZIO[Any, Nothing, zio.aws.transcribe.model.TranscriptFilterType] =
      ZIO.succeed(transcriptFilterType)
    def getAbsoluteTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("absoluteTimeRange", absoluteTimeRange)
    def getRelativeTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.RelativeTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("relativeTimeRange", relativeTimeRange)
    def getParticipantRole
        : ZIO[Any, AwsError, zio.aws.transcribe.model.ParticipantRole] =
      AwsError.unwrapOptionField("participantRole", participantRole)
    def getNegate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("negate", negate)
    def getTargets: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(targets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.TranscriptFilter
  ) extends zio.aws.transcribe.model.TranscriptFilter.ReadOnly {
    override val transcriptFilterType
        : zio.aws.transcribe.model.TranscriptFilterType =
      zio.aws.transcribe.model.TranscriptFilterType
        .wrap(impl.transcriptFilterType())
    override val absoluteTimeRange
        : Optional[zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.absoluteTimeRange())
        .map(value => zio.aws.transcribe.model.AbsoluteTimeRange.wrap(value))
    override val relativeTimeRange
        : Optional[zio.aws.transcribe.model.RelativeTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relativeTimeRange())
        .map(value => zio.aws.transcribe.model.RelativeTimeRange.wrap(value))
    override val participantRole
        : Optional[zio.aws.transcribe.model.ParticipantRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.participantRole())
        .map(value => zio.aws.transcribe.model.ParticipantRole.wrap(value))
    override val negate: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.negate())
      .map(value => value: Boolean)
    override val targets: List[NonEmptyString] = impl
      .targets()
      .asScala
      .map { item =>
        zio.aws.transcribe.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.TranscriptFilter
  ): zio.aws.transcribe.model.TranscriptFilter.ReadOnly = new Wrapper(impl)
}
