package zio.aws.transcribe.model
import scala.jdk.CollectionConverters._
sealed trait TranscriptionJobStatus {
  def unwrap
      : software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus
}
object TranscriptionJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus
  ): zio.aws.transcribe.model.TranscriptionJobStatus = value match {
    case software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus.QUEUED =>
      val r = QUEUED
      r
    case software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus.COMPLETED =>
      val r = COMPLETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribe.model.TranscriptionJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus =
      software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object QUEUED extends zio.aws.transcribe.model.TranscriptionJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus =
      software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus.QUEUED
  }
  case object IN_PROGRESS
      extends zio.aws.transcribe.model.TranscriptionJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus =
      software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus.IN_PROGRESS
  }
  case object FAILED extends zio.aws.transcribe.model.TranscriptionJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus =
      software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus.FAILED
  }
  case object COMPLETED
      extends zio.aws.transcribe.model.TranscriptionJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus =
      software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus.COMPLETED
  }
}
