package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.{TagKey, TranscribeArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: TranscribeArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.UntagResourceRequest
      .builder()
      .resourceArn(TranscribeArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.UntagResourceRequest.ReadOnly =
    zio.aws.transcribe.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.UntagResourceRequest =
      zio.aws.transcribe.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: TranscribeArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, TranscribeArn] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.UntagResourceRequest
  ) extends zio.aws.transcribe.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: TranscribeArn =
      zio.aws.transcribe.model.primitives.TranscribeArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.transcribe.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.UntagResourceRequest
  ): zio.aws.transcribe.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
