package zio.aws.transcribe.model
import scala.jdk.CollectionConverters._
sealed trait CLMLanguageCode {
  def unwrap: software.amazon.awssdk.services.transcribe.model.CLMLanguageCode
}
object CLMLanguageCode {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.CLMLanguageCode
  ): zio.aws.transcribe.model.CLMLanguageCode = value match {
    case software.amazon.awssdk.services.transcribe.model.CLMLanguageCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.CLMLanguageCode.EN_US =>
      val r = `en-US`
      r
    case software.amazon.awssdk.services.transcribe.model.CLMLanguageCode.HI_IN =>
      val r = `hi-IN`
      r
    case software.amazon.awssdk.services.transcribe.model.CLMLanguageCode.ES_US =>
      val r = `es-US`
      r
    case software.amazon.awssdk.services.transcribe.model.CLMLanguageCode.EN_GB =>
      val r = `en-GB`
      r
    case software.amazon.awssdk.services.transcribe.model.CLMLanguageCode.EN_AU =>
      val r = `en-AU`
      r
    case software.amazon.awssdk.services.transcribe.model.CLMLanguageCode.DE_DE =>
      val r = `de-DE`
      r
    case software.amazon.awssdk.services.transcribe.model.CLMLanguageCode.JA_JP =>
      val r = `ja-JP`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribe.model.CLMLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.CLMLanguageCode =
      software.amazon.awssdk.services.transcribe.model.CLMLanguageCode.UNKNOWN_TO_SDK_VERSION
  }
  case object `en-US` extends zio.aws.transcribe.model.CLMLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.CLMLanguageCode =
      software.amazon.awssdk.services.transcribe.model.CLMLanguageCode.EN_US
  }
  case object `hi-IN` extends zio.aws.transcribe.model.CLMLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.CLMLanguageCode =
      software.amazon.awssdk.services.transcribe.model.CLMLanguageCode.HI_IN
  }
  case object `es-US` extends zio.aws.transcribe.model.CLMLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.CLMLanguageCode =
      software.amazon.awssdk.services.transcribe.model.CLMLanguageCode.ES_US
  }
  case object `en-GB` extends zio.aws.transcribe.model.CLMLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.CLMLanguageCode =
      software.amazon.awssdk.services.transcribe.model.CLMLanguageCode.EN_GB
  }
  case object `en-AU` extends zio.aws.transcribe.model.CLMLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.CLMLanguageCode =
      software.amazon.awssdk.services.transcribe.model.CLMLanguageCode.EN_AU
  }
  case object `de-DE` extends zio.aws.transcribe.model.CLMLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.CLMLanguageCode =
      software.amazon.awssdk.services.transcribe.model.CLMLanguageCode.DE_DE
  }
  case object `ja-JP` extends zio.aws.transcribe.model.CLMLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.CLMLanguageCode =
      software.amazon.awssdk.services.transcribe.model.CLMLanguageCode.JA_JP
  }
}
