package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.{
  ModelName,
  VocabularyFilterName,
  VocabularyName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CallAnalyticsJobSettings(
    vocabularyName: Optional[VocabularyName] = Optional.Absent,
    vocabularyFilterName: Optional[VocabularyFilterName] = Optional.Absent,
    vocabularyFilterMethod: Optional[
      zio.aws.transcribe.model.VocabularyFilterMethod
    ] = Optional.Absent,
    languageModelName: Optional[ModelName] = Optional.Absent,
    contentRedaction: Optional[zio.aws.transcribe.model.ContentRedaction] =
      Optional.Absent,
    languageOptions: Optional[Iterable[zio.aws.transcribe.model.LanguageCode]] =
      Optional.Absent,
    languageIdSettings: Optional[Map[
      zio.aws.transcribe.model.LanguageCode,
      zio.aws.transcribe.model.LanguageIdSettings
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobSettings = {
    import CallAnalyticsJobSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobSettings
      .builder()
      .optionallyWith(
        vocabularyName.map(value =>
          VocabularyName.unwrap(value): java.lang.String
        )
      )(_.vocabularyName)
      .optionallyWith(
        vocabularyFilterName.map(value =>
          VocabularyFilterName.unwrap(value): java.lang.String
        )
      )(_.vocabularyFilterName)
      .optionallyWith(vocabularyFilterMethod.map(value => value.unwrap))(
        _.vocabularyFilterMethod
      )
      .optionallyWith(
        languageModelName.map(value =>
          ModelName.unwrap(value): java.lang.String
        )
      )(_.languageModelName)
      .optionallyWith(contentRedaction.map(value => value.buildAwsValue()))(
        _.contentRedaction
      )
      .optionallyWith(
        languageOptions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.languageOptionsWithStrings)
      .optionallyWith(
        languageIdSettings.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.languageIdSettingsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.CallAnalyticsJobSettings.ReadOnly =
    zio.aws.transcribe.model.CallAnalyticsJobSettings.wrap(buildAwsValue())
}
object CallAnalyticsJobSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.CallAnalyticsJobSettings =
      zio.aws.transcribe.model.CallAnalyticsJobSettings(
        vocabularyName.map(value => value),
        vocabularyFilterName.map(value => value),
        vocabularyFilterMethod.map(value => value),
        languageModelName.map(value => value),
        contentRedaction.map(value => value.asEditable),
        languageOptions.map(value => value),
        languageIdSettings.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def vocabularyName: Optional[VocabularyName]
    def vocabularyFilterName: Optional[VocabularyFilterName]
    def vocabularyFilterMethod
        : Optional[zio.aws.transcribe.model.VocabularyFilterMethod]
    def languageModelName: Optional[ModelName]
    def contentRedaction
        : Optional[zio.aws.transcribe.model.ContentRedaction.ReadOnly]
    def languageOptions: Optional[List[zio.aws.transcribe.model.LanguageCode]]
    def languageIdSettings: Optional[Map[
      zio.aws.transcribe.model.LanguageCode,
      zio.aws.transcribe.model.LanguageIdSettings.ReadOnly
    ]]
    def getVocabularyName: ZIO[Any, AwsError, VocabularyName] =
      AwsError.unwrapOptionField("vocabularyName", vocabularyName)
    def getVocabularyFilterName: ZIO[Any, AwsError, VocabularyFilterName] =
      AwsError.unwrapOptionField("vocabularyFilterName", vocabularyFilterName)
    def getVocabularyFilterMethod
        : ZIO[Any, AwsError, zio.aws.transcribe.model.VocabularyFilterMethod] =
      AwsError.unwrapOptionField(
        "vocabularyFilterMethod",
        vocabularyFilterMethod
      )
    def getLanguageModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("languageModelName", languageModelName)
    def getContentRedaction: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.ContentRedaction.ReadOnly
    ] = AwsError.unwrapOptionField("contentRedaction", contentRedaction)
    def getLanguageOptions
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.LanguageCode]] =
      AwsError.unwrapOptionField("languageOptions", languageOptions)
    def getLanguageIdSettings: ZIO[Any, AwsError, Map[
      zio.aws.transcribe.model.LanguageCode,
      zio.aws.transcribe.model.LanguageIdSettings.ReadOnly
    ]] = AwsError.unwrapOptionField("languageIdSettings", languageIdSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobSettings
  ) extends zio.aws.transcribe.model.CallAnalyticsJobSettings.ReadOnly {
    override val vocabularyName: Optional[VocabularyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyName())
        .map(value => zio.aws.transcribe.model.primitives.VocabularyName(value))
    override val vocabularyFilterName: Optional[VocabularyFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyFilterName())
        .map(value =>
          zio.aws.transcribe.model.primitives.VocabularyFilterName(value)
        )
    override val vocabularyFilterMethod
        : Optional[zio.aws.transcribe.model.VocabularyFilterMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyFilterMethod())
        .map(value =>
          zio.aws.transcribe.model.VocabularyFilterMethod.wrap(value)
        )
    override val languageModelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.languageModelName())
      .map(value => zio.aws.transcribe.model.primitives.ModelName(value))
    override val contentRedaction
        : Optional[zio.aws.transcribe.model.ContentRedaction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentRedaction())
        .map(value => zio.aws.transcribe.model.ContentRedaction.wrap(value))
    override val languageOptions
        : Optional[List[zio.aws.transcribe.model.LanguageCode]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.LanguageCode.wrap(item)
          }.toList
        )
    override val languageIdSettings: Optional[Map[
      zio.aws.transcribe.model.LanguageCode,
      zio.aws.transcribe.model.LanguageIdSettings.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.languageIdSettings())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.transcribe.model.LanguageCode.wrap(
              key
            ) -> zio.aws.transcribe.model.LanguageIdSettings.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobSettings
  ): zio.aws.transcribe.model.CallAnalyticsJobSettings.ReadOnly = new Wrapper(
    impl
  )
}
