package zio.aws.transcribe.model
import scala.jdk.CollectionConverters._
sealed trait CallAnalyticsJobStatus {
  def unwrap
      : software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobStatus
}
object CallAnalyticsJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobStatus
  ): zio.aws.transcribe.model.CallAnalyticsJobStatus = value match {
    case software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobStatus.QUEUED =>
      val r = QUEUED
      r
    case software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobStatus.COMPLETED =>
      val r = COMPLETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribe.model.CallAnalyticsJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobStatus =
      software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object QUEUED extends zio.aws.transcribe.model.CallAnalyticsJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobStatus =
      software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobStatus.QUEUED
  }
  case object IN_PROGRESS
      extends zio.aws.transcribe.model.CallAnalyticsJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobStatus =
      software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobStatus.IN_PROGRESS
  }
  case object FAILED extends zio.aws.transcribe.model.CallAnalyticsJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobStatus =
      software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobStatus.FAILED
  }
  case object COMPLETED
      extends zio.aws.transcribe.model.CallAnalyticsJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobStatus =
      software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobStatus.COMPLETED
  }
}
