package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContentRedaction(
    redactionType: zio.aws.transcribe.model.RedactionType,
    redactionOutput: zio.aws.transcribe.model.RedactionOutput,
    piiEntityTypes: Optional[Iterable[zio.aws.transcribe.model.PiiEntityType]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ContentRedaction = {
    import ContentRedaction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ContentRedaction
      .builder()
      .redactionType(redactionType.unwrap)
      .redactionOutput(redactionOutput.unwrap)
      .optionallyWith(
        piiEntityTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.piiEntityTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.ContentRedaction.ReadOnly =
    zio.aws.transcribe.model.ContentRedaction.wrap(buildAwsValue())
}
object ContentRedaction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ContentRedaction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ContentRedaction =
      zio.aws.transcribe.model.ContentRedaction(
        redactionType,
        redactionOutput,
        piiEntityTypes.map(value => value)
      )
    def redactionType: zio.aws.transcribe.model.RedactionType
    def redactionOutput: zio.aws.transcribe.model.RedactionOutput
    def piiEntityTypes: Optional[List[zio.aws.transcribe.model.PiiEntityType]]
    def getRedactionType
        : ZIO[Any, Nothing, zio.aws.transcribe.model.RedactionType] =
      ZIO.succeed(redactionType)
    def getRedactionOutput
        : ZIO[Any, Nothing, zio.aws.transcribe.model.RedactionOutput] =
      ZIO.succeed(redactionOutput)
    def getPiiEntityTypes
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.PiiEntityType]] =
      AwsError.unwrapOptionField("piiEntityTypes", piiEntityTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ContentRedaction
  ) extends zio.aws.transcribe.model.ContentRedaction.ReadOnly {
    override val redactionType: zio.aws.transcribe.model.RedactionType =
      zio.aws.transcribe.model.RedactionType.wrap(impl.redactionType())
    override val redactionOutput: zio.aws.transcribe.model.RedactionOutput =
      zio.aws.transcribe.model.RedactionOutput.wrap(impl.redactionOutput())
    override val piiEntityTypes
        : Optional[List[zio.aws.transcribe.model.PiiEntityType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.piiEntityTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.PiiEntityType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ContentRedaction
  ): zio.aws.transcribe.model.ContentRedaction.ReadOnly = new Wrapper(impl)
}
