package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.CategoryName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCallAnalyticsCategoryRequest(
    categoryName: CategoryName,
    rules: Iterable[zio.aws.transcribe.model.Rule],
    inputType: Optional[zio.aws.transcribe.model.InputType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryRequest = {
    import CreateCallAnalyticsCategoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryRequest
      .builder()
      .categoryName(CategoryName.unwrap(categoryName): java.lang.String)
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(inputType.map(value => value.unwrap))(_.inputType)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.CreateCallAnalyticsCategoryRequest.ReadOnly =
    zio.aws.transcribe.model.CreateCallAnalyticsCategoryRequest
      .wrap(buildAwsValue())
}
object CreateCallAnalyticsCategoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.transcribe.model.CreateCallAnalyticsCategoryRequest =
      zio.aws.transcribe.model.CreateCallAnalyticsCategoryRequest(
        categoryName,
        rules.map { item =>
          item.asEditable
        },
        inputType.map(value => value)
      )
    def categoryName: CategoryName
    def rules: List[zio.aws.transcribe.model.Rule.ReadOnly]
    def inputType: Optional[zio.aws.transcribe.model.InputType]
    def getCategoryName: ZIO[Any, Nothing, CategoryName] =
      ZIO.succeed(categoryName)
    def getRules
        : ZIO[Any, Nothing, List[zio.aws.transcribe.model.Rule.ReadOnly]] =
      ZIO.succeed(rules)
    def getInputType: ZIO[Any, AwsError, zio.aws.transcribe.model.InputType] =
      AwsError.unwrapOptionField("inputType", inputType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryRequest
  ) extends zio.aws.transcribe.model.CreateCallAnalyticsCategoryRequest.ReadOnly {
    override val categoryName: CategoryName =
      zio.aws.transcribe.model.primitives.CategoryName(impl.categoryName())
    override val rules: List[zio.aws.transcribe.model.Rule.ReadOnly] = impl
      .rules()
      .asScala
      .map { item =>
        zio.aws.transcribe.model.Rule.wrap(item)
      }
      .toList
    override val inputType: Optional[zio.aws.transcribe.model.InputType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputType())
        .map(value => zio.aws.transcribe.model.InputType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryRequest
  ): zio.aws.transcribe.model.CreateCallAnalyticsCategoryRequest.ReadOnly =
    new Wrapper(impl)
}
