package zio.aws.transcribe.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{
  FailureReason,
  DateTime,
  VocabularyName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateVocabularyResponse(
    vocabularyName: Optional[VocabularyName] = Optional.Absent,
    languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      Optional.Absent,
    vocabularyState: Optional[zio.aws.transcribe.model.VocabularyState] =
      Optional.Absent,
    lastModifiedTime: Optional[DateTime] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.CreateVocabularyResponse = {
    import CreateVocabularyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.CreateVocabularyResponse
      .builder()
      .optionallyWith(
        vocabularyName.map(value =>
          VocabularyName.unwrap(value): java.lang.String
        )
      )(_.vocabularyName)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(vocabularyState.map(value => value.unwrap))(
        _.vocabularyState
      )
      .optionallyWith(
        lastModifiedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.CreateVocabularyResponse.ReadOnly =
    zio.aws.transcribe.model.CreateVocabularyResponse.wrap(buildAwsValue())
}
object CreateVocabularyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.CreateVocabularyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.CreateVocabularyResponse =
      zio.aws.transcribe.model.CreateVocabularyResponse(
        vocabularyName.map(value => value),
        languageCode.map(value => value),
        vocabularyState.map(value => value),
        lastModifiedTime.map(value => value),
        failureReason.map(value => value)
      )
    def vocabularyName: Optional[VocabularyName]
    def languageCode: Optional[zio.aws.transcribe.model.LanguageCode]
    def vocabularyState: Optional[zio.aws.transcribe.model.VocabularyState]
    def lastModifiedTime: Optional[DateTime]
    def failureReason: Optional[FailureReason]
    def getVocabularyName: ZIO[Any, AwsError, VocabularyName] =
      AwsError.unwrapOptionField("vocabularyName", vocabularyName)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getVocabularyState
        : ZIO[Any, AwsError, zio.aws.transcribe.model.VocabularyState] =
      AwsError.unwrapOptionField("vocabularyState", vocabularyState)
    def getLastModifiedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.CreateVocabularyResponse
  ) extends zio.aws.transcribe.model.CreateVocabularyResponse.ReadOnly {
    override val vocabularyName: Optional[VocabularyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyName())
        .map(value => zio.aws.transcribe.model.primitives.VocabularyName(value))
    override val languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.transcribe.model.LanguageCode.wrap(value))
    override val vocabularyState
        : Optional[zio.aws.transcribe.model.VocabularyState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyState())
        .map(value => zio.aws.transcribe.model.VocabularyState.wrap(value))
    override val lastModifiedTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.transcribe.model.primitives.FailureReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.CreateVocabularyResponse
  ): zio.aws.transcribe.model.CreateVocabularyResponse.ReadOnly = new Wrapper(
    impl
  )
}
