package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.VocabularyFilterName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVocabularyFilterRequest(
    vocabularyFilterName: VocabularyFilterName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.DeleteVocabularyFilterRequest = {
    import DeleteVocabularyFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.DeleteVocabularyFilterRequest
      .builder()
      .vocabularyFilterName(
        VocabularyFilterName.unwrap(vocabularyFilterName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.DeleteVocabularyFilterRequest.ReadOnly =
    zio.aws.transcribe.model.DeleteVocabularyFilterRequest.wrap(buildAwsValue())
}
object DeleteVocabularyFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.DeleteVocabularyFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.DeleteVocabularyFilterRequest =
      zio.aws.transcribe.model
        .DeleteVocabularyFilterRequest(vocabularyFilterName)
    def vocabularyFilterName: VocabularyFilterName
    def getVocabularyFilterName: ZIO[Any, Nothing, VocabularyFilterName] =
      ZIO.succeed(vocabularyFilterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.DeleteVocabularyFilterRequest
  ) extends zio.aws.transcribe.model.DeleteVocabularyFilterRequest.ReadOnly {
    override val vocabularyFilterName: VocabularyFilterName =
      zio.aws.transcribe.model.primitives
        .VocabularyFilterName(impl.vocabularyFilterName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.DeleteVocabularyFilterRequest
  ): zio.aws.transcribe.model.DeleteVocabularyFilterRequest.ReadOnly =
    new Wrapper(impl)
}
