package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.TranscriptionJobName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetTranscriptionJobRequest(
    transcriptionJobName: TranscriptionJobName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobRequest = {
    import GetTranscriptionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobRequest
      .builder()
      .transcriptionJobName(
        TranscriptionJobName.unwrap(transcriptionJobName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.GetTranscriptionJobRequest.ReadOnly =
    zio.aws.transcribe.model.GetTranscriptionJobRequest.wrap(buildAwsValue())
}
object GetTranscriptionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.GetTranscriptionJobRequest =
      zio.aws.transcribe.model.GetTranscriptionJobRequest(transcriptionJobName)
    def transcriptionJobName: TranscriptionJobName
    def getTranscriptionJobName: ZIO[Any, Nothing, TranscriptionJobName] =
      ZIO.succeed(transcriptionJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobRequest
  ) extends zio.aws.transcribe.model.GetTranscriptionJobRequest.ReadOnly {
    override val transcriptionJobName: TranscriptionJobName =
      zio.aws.transcribe.model.primitives
        .TranscriptionJobName(impl.transcriptionJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobRequest
  ): zio.aws.transcribe.model.GetTranscriptionJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
