package zio.aws.transcribe.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{Uri, DateTime, VocabularyFilterName}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetVocabularyFilterResponse(
    vocabularyFilterName: Optional[VocabularyFilterName] = Optional.Absent,
    languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      Optional.Absent,
    lastModifiedTime: Optional[DateTime] = Optional.Absent,
    downloadUri: Optional[Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.GetVocabularyFilterResponse = {
    import GetVocabularyFilterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.GetVocabularyFilterResponse
      .builder()
      .optionallyWith(
        vocabularyFilterName.map(value =>
          VocabularyFilterName.unwrap(value): java.lang.String
        )
      )(_.vocabularyFilterName)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        lastModifiedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        downloadUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.downloadUri)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.GetVocabularyFilterResponse.ReadOnly =
    zio.aws.transcribe.model.GetVocabularyFilterResponse.wrap(buildAwsValue())
}
object GetVocabularyFilterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.GetVocabularyFilterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.GetVocabularyFilterResponse =
      zio.aws.transcribe.model.GetVocabularyFilterResponse(
        vocabularyFilterName.map(value => value),
        languageCode.map(value => value),
        lastModifiedTime.map(value => value),
        downloadUri.map(value => value)
      )
    def vocabularyFilterName: Optional[VocabularyFilterName]
    def languageCode: Optional[zio.aws.transcribe.model.LanguageCode]
    def lastModifiedTime: Optional[DateTime]
    def downloadUri: Optional[Uri]
    def getVocabularyFilterName: ZIO[Any, AwsError, VocabularyFilterName] =
      AwsError.unwrapOptionField("vocabularyFilterName", vocabularyFilterName)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getLastModifiedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getDownloadUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("downloadUri", downloadUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.GetVocabularyFilterResponse
  ) extends zio.aws.transcribe.model.GetVocabularyFilterResponse.ReadOnly {
    override val vocabularyFilterName: Optional[VocabularyFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyFilterName())
        .map(value =>
          zio.aws.transcribe.model.primitives.VocabularyFilterName(value)
        )
    override val languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.transcribe.model.LanguageCode.wrap(value))
    override val lastModifiedTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val downloadUri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.downloadUri())
      .map(value => zio.aws.transcribe.model.primitives.Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.GetVocabularyFilterResponse
  ): zio.aws.transcribe.model.GetVocabularyFilterResponse.ReadOnly =
    new Wrapper(impl)
}
