package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.{DataAccessRoleArn, Uri}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InputDataConfig(
    s3Uri: Uri,
    tuningDataS3Uri: Optional[Uri] = Optional.Absent,
    dataAccessRoleArn: DataAccessRoleArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.InputDataConfig = {
    import InputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.InputDataConfig
      .builder()
      .s3Uri(Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(
        tuningDataS3Uri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.tuningDataS3Uri)
      .dataAccessRoleArn(
        DataAccessRoleArn.unwrap(dataAccessRoleArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.InputDataConfig.ReadOnly =
    zio.aws.transcribe.model.InputDataConfig.wrap(buildAwsValue())
}
object InputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.InputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.InputDataConfig =
      zio.aws.transcribe.model.InputDataConfig(
        s3Uri,
        tuningDataS3Uri.map(value => value),
        dataAccessRoleArn
      )
    def s3Uri: Uri
    def tuningDataS3Uri: Optional[Uri]
    def dataAccessRoleArn: DataAccessRoleArn
    def getS3Uri: ZIO[Any, Nothing, Uri] = ZIO.succeed(s3Uri)
    def getTuningDataS3Uri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("tuningDataS3Uri", tuningDataS3Uri)
    def getDataAccessRoleArn: ZIO[Any, Nothing, DataAccessRoleArn] =
      ZIO.succeed(dataAccessRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.InputDataConfig
  ) extends zio.aws.transcribe.model.InputDataConfig.ReadOnly {
    override val s3Uri: Uri =
      zio.aws.transcribe.model.primitives.Uri(impl.s3Uri())
    override val tuningDataS3Uri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.tuningDataS3Uri())
      .map(value => zio.aws.transcribe.model.primitives.Uri(value))
    override val dataAccessRoleArn: DataAccessRoleArn =
      zio.aws.transcribe.model.primitives
        .DataAccessRoleArn(impl.dataAccessRoleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.InputDataConfig
  ): zio.aws.transcribe.model.InputDataConfig.ReadOnly = new Wrapper(impl)
}
