package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.TimestampMilliseconds
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InterruptionFilter(
    threshold: Optional[TimestampMilliseconds] = Optional.Absent,
    participantRole: Optional[zio.aws.transcribe.model.ParticipantRole] =
      Optional.Absent,
    absoluteTimeRange: Optional[zio.aws.transcribe.model.AbsoluteTimeRange] =
      Optional.Absent,
    relativeTimeRange: Optional[zio.aws.transcribe.model.RelativeTimeRange] =
      Optional.Absent,
    negate: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.InterruptionFilter = {
    import InterruptionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.InterruptionFilter
      .builder()
      .optionallyWith(
        threshold.map(value =>
          TimestampMilliseconds.unwrap(value): java.lang.Long
        )
      )(_.threshold)
      .optionallyWith(participantRole.map(value => value.unwrap))(
        _.participantRole
      )
      .optionallyWith(absoluteTimeRange.map(value => value.buildAwsValue()))(
        _.absoluteTimeRange
      )
      .optionallyWith(relativeTimeRange.map(value => value.buildAwsValue()))(
        _.relativeTimeRange
      )
      .optionallyWith(negate.map(value => value: java.lang.Boolean))(_.negate)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.InterruptionFilter.ReadOnly =
    zio.aws.transcribe.model.InterruptionFilter.wrap(buildAwsValue())
}
object InterruptionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.InterruptionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.InterruptionFilter =
      zio.aws.transcribe.model.InterruptionFilter(
        threshold.map(value => value),
        participantRole.map(value => value),
        absoluteTimeRange.map(value => value.asEditable),
        relativeTimeRange.map(value => value.asEditable),
        negate.map(value => value)
      )
    def threshold: Optional[TimestampMilliseconds]
    def participantRole: Optional[zio.aws.transcribe.model.ParticipantRole]
    def absoluteTimeRange
        : Optional[zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly]
    def relativeTimeRange
        : Optional[zio.aws.transcribe.model.RelativeTimeRange.ReadOnly]
    def negate: Optional[Boolean]
    def getThreshold: ZIO[Any, AwsError, TimestampMilliseconds] =
      AwsError.unwrapOptionField("threshold", threshold)
    def getParticipantRole
        : ZIO[Any, AwsError, zio.aws.transcribe.model.ParticipantRole] =
      AwsError.unwrapOptionField("participantRole", participantRole)
    def getAbsoluteTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("absoluteTimeRange", absoluteTimeRange)
    def getRelativeTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.RelativeTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("relativeTimeRange", relativeTimeRange)
    def getNegate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("negate", negate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.InterruptionFilter
  ) extends zio.aws.transcribe.model.InterruptionFilter.ReadOnly {
    override val threshold: Optional[TimestampMilliseconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.threshold())
        .map(value =>
          zio.aws.transcribe.model.primitives.TimestampMilliseconds(value)
        )
    override val participantRole
        : Optional[zio.aws.transcribe.model.ParticipantRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.participantRole())
        .map(value => zio.aws.transcribe.model.ParticipantRole.wrap(value))
    override val absoluteTimeRange
        : Optional[zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.absoluteTimeRange())
        .map(value => zio.aws.transcribe.model.AbsoluteTimeRange.wrap(value))
    override val relativeTimeRange
        : Optional[zio.aws.transcribe.model.RelativeTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relativeTimeRange())
        .map(value => zio.aws.transcribe.model.RelativeTimeRange.wrap(value))
    override val negate: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.negate())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.InterruptionFilter
  ): zio.aws.transcribe.model.InterruptionFilter.ReadOnly = new Wrapper(impl)
}
