package zio.aws.transcribe.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{MaxResults, NextToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListCallAnalyticsCategoriesRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest = {
    import ListCallAnalyticsCategoriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.ListCallAnalyticsCategoriesRequest.ReadOnly =
    zio.aws.transcribe.model.ListCallAnalyticsCategoriesRequest
      .wrap(buildAwsValue())
}
object ListCallAnalyticsCategoriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.transcribe.model.ListCallAnalyticsCategoriesRequest =
      zio.aws.transcribe.model.ListCallAnalyticsCategoriesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest
  ) extends zio.aws.transcribe.model.ListCallAnalyticsCategoriesRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transcribe.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.transcribe.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest
  ): zio.aws.transcribe.model.ListCallAnalyticsCategoriesRequest.ReadOnly =
    new Wrapper(impl)
}
