package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVocabularyFiltersResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    vocabularyFilters: Optional[
      Iterable[zio.aws.transcribe.model.VocabularyFilterInfo]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse = {
    import ListVocabularyFiltersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        vocabularyFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vocabularyFilters)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.ListVocabularyFiltersResponse.ReadOnly =
    zio.aws.transcribe.model.ListVocabularyFiltersResponse.wrap(buildAwsValue())
}
object ListVocabularyFiltersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ListVocabularyFiltersResponse =
      zio.aws.transcribe.model.ListVocabularyFiltersResponse(
        nextToken.map(value => value),
        vocabularyFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def vocabularyFilters
        : Optional[List[zio.aws.transcribe.model.VocabularyFilterInfo.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVocabularyFilters: ZIO[Any, AwsError, List[
      zio.aws.transcribe.model.VocabularyFilterInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("vocabularyFilters", vocabularyFilters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse
  ) extends zio.aws.transcribe.model.ListVocabularyFiltersResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transcribe.model.primitives.NextToken(value))
    override val vocabularyFilters: Optional[
      List[zio.aws.transcribe.model.VocabularyFilterInfo.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vocabularyFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribe.model.VocabularyFilterInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse
  ): zio.aws.transcribe.model.ListVocabularyFiltersResponse.ReadOnly =
    new Wrapper(impl)
}
