package zio.aws.transcribe.model
import scala.jdk.CollectionConverters._
sealed trait ModelStatus {
  def unwrap: software.amazon.awssdk.services.transcribe.model.ModelStatus
}
object ModelStatus {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.ModelStatus
  ): zio.aws.transcribe.model.ModelStatus = value match {
    case software.amazon.awssdk.services.transcribe.model.ModelStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.ModelStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.transcribe.model.ModelStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.transcribe.model.ModelStatus.COMPLETED =>
      val r = COMPLETED
      r
  }
  case object unknownToSdkVersion extends zio.aws.transcribe.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.ModelStatus =
      software.amazon.awssdk.services.transcribe.model.ModelStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.transcribe.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.ModelStatus =
      software.amazon.awssdk.services.transcribe.model.ModelStatus.IN_PROGRESS
  }
  case object FAILED extends zio.aws.transcribe.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.ModelStatus =
      software.amazon.awssdk.services.transcribe.model.ModelStatus.FAILED
  }
  case object COMPLETED extends zio.aws.transcribe.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.ModelStatus =
      software.amazon.awssdk.services.transcribe.model.ModelStatus.COMPLETED
  }
}
