package zio.aws.transcribe.model
import scala.jdk.CollectionConverters._
sealed trait SubtitleFormat {
  def unwrap: software.amazon.awssdk.services.transcribe.model.SubtitleFormat
}
object SubtitleFormat {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.SubtitleFormat
  ): zio.aws.transcribe.model.SubtitleFormat = value match {
    case software.amazon.awssdk.services.transcribe.model.SubtitleFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.SubtitleFormat.VTT =>
      val r = vtt
      r
    case software.amazon.awssdk.services.transcribe.model.SubtitleFormat.SRT =>
      val r = srt
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribe.model.SubtitleFormat {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.SubtitleFormat =
      software.amazon.awssdk.services.transcribe.model.SubtitleFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object vtt extends zio.aws.transcribe.model.SubtitleFormat {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.SubtitleFormat =
      software.amazon.awssdk.services.transcribe.model.SubtitleFormat.VTT
  }
  case object srt extends zio.aws.transcribe.model.SubtitleFormat {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.SubtitleFormat =
      software.amazon.awssdk.services.transcribe.model.SubtitleFormat.SRT
  }
}
