package zio.aws.transcribe.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.SubtitleOutputStartIndex
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Subtitles(
    formats: Optional[Iterable[zio.aws.transcribe.model.SubtitleFormat]] =
      Optional.Absent,
    outputStartIndex: Optional[SubtitleOutputStartIndex] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.Subtitles = {
    import Subtitles.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.Subtitles
      .builder()
      .optionallyWith(
        formats.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.formatsWithStrings)
      .optionallyWith(
        outputStartIndex.map(value =>
          SubtitleOutputStartIndex.unwrap(value): Integer
        )
      )(_.outputStartIndex)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.Subtitles.ReadOnly =
    zio.aws.transcribe.model.Subtitles.wrap(buildAwsValue())
}
object Subtitles {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.Subtitles
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.Subtitles =
      zio.aws.transcribe.model.Subtitles(
        formats.map(value => value),
        outputStartIndex.map(value => value)
      )
    def formats: Optional[List[zio.aws.transcribe.model.SubtitleFormat]]
    def outputStartIndex: Optional[SubtitleOutputStartIndex]
    def getFormats
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.SubtitleFormat]] =
      AwsError.unwrapOptionField("formats", formats)
    def getOutputStartIndex: ZIO[Any, AwsError, SubtitleOutputStartIndex] =
      AwsError.unwrapOptionField("outputStartIndex", outputStartIndex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.Subtitles
  ) extends zio.aws.transcribe.model.Subtitles.ReadOnly {
    override val formats
        : Optional[List[zio.aws.transcribe.model.SubtitleFormat]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formats())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.SubtitleFormat.wrap(item)
          }.toList
        )
    override val outputStartIndex: Optional[SubtitleOutputStartIndex] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputStartIndex())
        .map(value =>
          zio.aws.transcribe.model.primitives.SubtitleOutputStartIndex(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.Subtitles
  ): zio.aws.transcribe.model.Subtitles.ReadOnly = new Wrapper(impl)
}
