package zio.aws.transcribe.model
import scala.jdk.CollectionConverters._
sealed trait ToxicityCategory {
  def unwrap: software.amazon.awssdk.services.transcribe.model.ToxicityCategory
}
object ToxicityCategory {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.ToxicityCategory
  ): zio.aws.transcribe.model.ToxicityCategory = value match {
    case software.amazon.awssdk.services.transcribe.model.ToxicityCategory.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.ToxicityCategory.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribe.model.ToxicityCategory {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.ToxicityCategory =
      software.amazon.awssdk.services.transcribe.model.ToxicityCategory.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.transcribe.model.ToxicityCategory {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.ToxicityCategory =
      software.amazon.awssdk.services.transcribe.model.ToxicityCategory.ALL
  }
}
