package zio.aws.transcribe.model
import scala.jdk.CollectionConverters._
sealed trait TranscriptFilterType {
  def unwrap
      : software.amazon.awssdk.services.transcribe.model.TranscriptFilterType
}
object TranscriptFilterType {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.TranscriptFilterType
  ): zio.aws.transcribe.model.TranscriptFilterType = value match {
    case software.amazon.awssdk.services.transcribe.model.TranscriptFilterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.TranscriptFilterType.EXACT =>
      val r = EXACT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribe.model.TranscriptFilterType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.TranscriptFilterType =
      software.amazon.awssdk.services.transcribe.model.TranscriptFilterType.UNKNOWN_TO_SDK_VERSION
  }
  case object EXACT extends zio.aws.transcribe.model.TranscriptFilterType {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.TranscriptFilterType =
      software.amazon.awssdk.services.transcribe.model.TranscriptFilterType.EXACT
  }
}
