package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{SourceFileLocation, WorkflowStepName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CopyStepDetails(
    name: Option[WorkflowStepName] = None,
    destinationFileLocation: Option[zio.aws.transfer.model.InputFileLocation] =
      None,
    overwriteExisting: Option[zio.aws.transfer.model.OverwriteExisting] = None,
    sourceFileLocation: Option[SourceFileLocation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.CopyStepDetails = {
    import CopyStepDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.CopyStepDetails
      .builder()
      .optionallyWith(
        name.map(value => WorkflowStepName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        destinationFileLocation.map(value => value.buildAwsValue())
      )(_.destinationFileLocation)
      .optionallyWith(overwriteExisting.map(value => value.unwrap))(
        _.overwriteExisting
      )
      .optionallyWith(
        sourceFileLocation.map(value =>
          SourceFileLocation.unwrap(value): java.lang.String
        )
      )(_.sourceFileLocation)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.CopyStepDetails.ReadOnly =
    zio.aws.transfer.model.CopyStepDetails.wrap(buildAwsValue())
}
object CopyStepDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.CopyStepDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.CopyStepDetails =
      zio.aws.transfer.model.CopyStepDetails(
        name.map(value => value),
        destinationFileLocation.map(value => value.asEditable),
        overwriteExisting.map(value => value),
        sourceFileLocation.map(value => value)
      )
    def name: Option[WorkflowStepName]
    def destinationFileLocation
        : Option[zio.aws.transfer.model.InputFileLocation.ReadOnly]
    def overwriteExisting: Option[zio.aws.transfer.model.OverwriteExisting]
    def sourceFileLocation: Option[SourceFileLocation]
    def getName: ZIO[Any, AwsError, WorkflowStepName] =
      AwsError.unwrapOptionField("name", name)
    def getDestinationFileLocation: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.InputFileLocation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "destinationFileLocation",
      destinationFileLocation
    )
    def getOverwriteExisting
        : ZIO[Any, AwsError, zio.aws.transfer.model.OverwriteExisting] =
      AwsError.unwrapOptionField("overwriteExisting", overwriteExisting)
    def getSourceFileLocation: ZIO[Any, AwsError, SourceFileLocation] =
      AwsError.unwrapOptionField("sourceFileLocation", sourceFileLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.CopyStepDetails
  ) extends zio.aws.transfer.model.CopyStepDetails.ReadOnly {
    override val name: Option[WorkflowStepName] = scala
      .Option(impl.name())
      .map(value => zio.aws.transfer.model.primitives.WorkflowStepName(value))
    override val destinationFileLocation
        : Option[zio.aws.transfer.model.InputFileLocation.ReadOnly] = scala
      .Option(impl.destinationFileLocation())
      .map(value => zio.aws.transfer.model.InputFileLocation.wrap(value))
    override val overwriteExisting
        : Option[zio.aws.transfer.model.OverwriteExisting] = scala
      .Option(impl.overwriteExisting())
      .map(value => zio.aws.transfer.model.OverwriteExisting.wrap(value))
    override val sourceFileLocation: Option[SourceFileLocation] = scala
      .Option(impl.sourceFileLocation())
      .map(value => zio.aws.transfer.model.primitives.SourceFileLocation(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.CopyStepDetails
  ): zio.aws.transfer.model.CopyStepDetails.ReadOnly = new Wrapper(impl)
}
