package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.ServerId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateServerResponse(serverId: ServerId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.CreateServerResponse = {
    import CreateServerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.CreateServerResponse
      .builder()
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.CreateServerResponse.ReadOnly =
    zio.aws.transfer.model.CreateServerResponse.wrap(buildAwsValue())
}
object CreateServerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.CreateServerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.CreateServerResponse =
      zio.aws.transfer.model.CreateServerResponse(serverId)
    def serverId: ServerId
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.CreateServerResponse
  ) extends zio.aws.transfer.model.CreateServerResponse.ReadOnly {
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.CreateServerResponse
  ): zio.aws.transfer.model.CreateServerResponse.ReadOnly = new Wrapper(impl)
}
