package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  ServerId,
  HomeDirectory,
  Policy,
  SshPublicKeyBody,
  Role,
  UserName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateUserRequest(
    homeDirectory: Option[HomeDirectory] = None,
    homeDirectoryType: Option[zio.aws.transfer.model.HomeDirectoryType] = None,
    homeDirectoryMappings: Option[
      Iterable[zio.aws.transfer.model.HomeDirectoryMapEntry]
    ] = None,
    policy: Option[Policy] = None,
    posixProfile: Option[zio.aws.transfer.model.PosixProfile] = None,
    role: Role,
    serverId: ServerId,
    sshPublicKeyBody: Option[SshPublicKeyBody] = None,
    tags: Option[Iterable[zio.aws.transfer.model.Tag]] = None,
    userName: UserName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.CreateUserRequest = {
    import CreateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.CreateUserRequest
      .builder()
      .optionallyWith(
        homeDirectory.map(value =>
          HomeDirectory.unwrap(value): java.lang.String
        )
      )(_.homeDirectory)
      .optionallyWith(homeDirectoryType.map(value => value.unwrap))(
        _.homeDirectoryType
      )
      .optionallyWith(
        homeDirectoryMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.homeDirectoryMappings)
      .optionallyWith(
        policy.map(value => Policy.unwrap(value): java.lang.String)
      )(_.policy)
      .optionallyWith(posixProfile.map(value => value.buildAwsValue()))(
        _.posixProfile
      )
      .role(Role.unwrap(role): java.lang.String)
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .optionallyWith(
        sshPublicKeyBody.map(value =>
          SshPublicKeyBody.unwrap(value): java.lang.String
        )
      )(_.sshPublicKeyBody)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .userName(UserName.unwrap(userName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.CreateUserRequest.ReadOnly =
    zio.aws.transfer.model.CreateUserRequest.wrap(buildAwsValue())
}
object CreateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.CreateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.CreateUserRequest =
      zio.aws.transfer.model.CreateUserRequest(
        homeDirectory.map(value => value),
        homeDirectoryType.map(value => value),
        homeDirectoryMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        policy.map(value => value),
        posixProfile.map(value => value.asEditable),
        role,
        serverId,
        sshPublicKeyBody.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userName
      )
    def homeDirectory: Option[HomeDirectory]
    def homeDirectoryType: Option[zio.aws.transfer.model.HomeDirectoryType]
    def homeDirectoryMappings
        : Option[List[zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly]]
    def policy: Option[Policy]
    def posixProfile: Option[zio.aws.transfer.model.PosixProfile.ReadOnly]
    def role: Role
    def serverId: ServerId
    def sshPublicKeyBody: Option[SshPublicKeyBody]
    def tags: Option[List[zio.aws.transfer.model.Tag.ReadOnly]]
    def userName: UserName
    def getHomeDirectory: ZIO[Any, AwsError, HomeDirectory] =
      AwsError.unwrapOptionField("homeDirectory", homeDirectory)
    def getHomeDirectoryType
        : ZIO[Any, AwsError, zio.aws.transfer.model.HomeDirectoryType] =
      AwsError.unwrapOptionField("homeDirectoryType", homeDirectoryType)
    def getHomeDirectoryMappings: ZIO[Any, AwsError, List[
      zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly
    ]] =
      AwsError.unwrapOptionField("homeDirectoryMappings", homeDirectoryMappings)
    def getPolicy: ZIO[Any, AwsError, Policy] =
      AwsError.unwrapOptionField("policy", policy)
    def getPosixProfile
        : ZIO[Any, AwsError, zio.aws.transfer.model.PosixProfile.ReadOnly] =
      AwsError.unwrapOptionField("posixProfile", posixProfile)
    def getRole: ZIO[Any, Nothing, Role] = ZIO.succeed(role)
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getSshPublicKeyBody: ZIO[Any, AwsError, SshPublicKeyBody] =
      AwsError.unwrapOptionField("sshPublicKeyBody", sshPublicKeyBody)
    def getTags: ZIO[Any, AwsError, List[zio.aws.transfer.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUserName: ZIO[Any, Nothing, UserName] = ZIO.succeed(userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.CreateUserRequest
  ) extends zio.aws.transfer.model.CreateUserRequest.ReadOnly {
    override val homeDirectory: Option[HomeDirectory] = scala
      .Option(impl.homeDirectory())
      .map(value => zio.aws.transfer.model.primitives.HomeDirectory(value))
    override val homeDirectoryType
        : Option[zio.aws.transfer.model.HomeDirectoryType] = scala
      .Option(impl.homeDirectoryType())
      .map(value => zio.aws.transfer.model.HomeDirectoryType.wrap(value))
    override val homeDirectoryMappings
        : Option[List[zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly]] =
      scala
        .Option(impl.homeDirectoryMappings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.HomeDirectoryMapEntry.wrap(item)
          }.toList
        )
    override val policy: Option[Policy] = scala
      .Option(impl.policy())
      .map(value => zio.aws.transfer.model.primitives.Policy(value))
    override val posixProfile
        : Option[zio.aws.transfer.model.PosixProfile.ReadOnly] = scala
      .Option(impl.posixProfile())
      .map(value => zio.aws.transfer.model.PosixProfile.wrap(value))
    override val role: Role =
      zio.aws.transfer.model.primitives.Role(impl.role())
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val sshPublicKeyBody: Option[SshPublicKeyBody] = scala
      .Option(impl.sshPublicKeyBody())
      .map(value => zio.aws.transfer.model.primitives.SshPublicKeyBody(value))
    override val tags: Option[List[zio.aws.transfer.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transfer.model.Tag.wrap(item)
        }.toList
      )
    override val userName: UserName =
      zio.aws.transfer.model.primitives.UserName(impl.userName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.CreateUserRequest
  ): zio.aws.transfer.model.CreateUserRequest.ReadOnly = new Wrapper(impl)
}
