package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.WorkflowDescription
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateWorkflowRequest(
    description: Option[WorkflowDescription] = None,
    steps: Iterable[zio.aws.transfer.model.WorkflowStep],
    onExceptionSteps: Option[Iterable[zio.aws.transfer.model.WorkflowStep]] =
      None,
    tags: Option[Iterable[zio.aws.transfer.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.CreateWorkflowRequest = {
    import CreateWorkflowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.CreateWorkflowRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          WorkflowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .steps(steps.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        onExceptionSteps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.onExceptionSteps)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.CreateWorkflowRequest.ReadOnly =
    zio.aws.transfer.model.CreateWorkflowRequest.wrap(buildAwsValue())
}
object CreateWorkflowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.CreateWorkflowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.CreateWorkflowRequest =
      zio.aws.transfer.model.CreateWorkflowRequest(
        description.map(value => value),
        steps.map { item =>
          item.asEditable
        },
        onExceptionSteps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def description: Option[WorkflowDescription]
    def steps: List[zio.aws.transfer.model.WorkflowStep.ReadOnly]
    def onExceptionSteps
        : Option[List[zio.aws.transfer.model.WorkflowStep.ReadOnly]]
    def tags: Option[List[zio.aws.transfer.model.Tag.ReadOnly]]
    def getDescription: ZIO[Any, AwsError, WorkflowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSteps: ZIO[Any, Nothing, List[
      zio.aws.transfer.model.WorkflowStep.ReadOnly
    ]] = ZIO.succeed(steps)
    def getOnExceptionSteps: ZIO[Any, AwsError, List[
      zio.aws.transfer.model.WorkflowStep.ReadOnly
    ]] = AwsError.unwrapOptionField("onExceptionSteps", onExceptionSteps)
    def getTags: ZIO[Any, AwsError, List[zio.aws.transfer.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.CreateWorkflowRequest
  ) extends zio.aws.transfer.model.CreateWorkflowRequest.ReadOnly {
    override val description: Option[WorkflowDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.transfer.model.primitives.WorkflowDescription(value)
      )
    override val steps: List[zio.aws.transfer.model.WorkflowStep.ReadOnly] =
      impl
        .steps()
        .asScala
        .map { item =>
          zio.aws.transfer.model.WorkflowStep.wrap(item)
        }
        .toList
    override val onExceptionSteps
        : Option[List[zio.aws.transfer.model.WorkflowStep.ReadOnly]] = scala
      .Option(impl.onExceptionSteps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transfer.model.WorkflowStep.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.transfer.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transfer.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.CreateWorkflowRequest
  ): zio.aws.transfer.model.CreateWorkflowRequest.ReadOnly = new Wrapper(impl)
}
