package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{UserName, ServerId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteUserRequest(serverId: ServerId, userName: UserName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DeleteUserRequest = {
    import DeleteUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DeleteUserRequest
      .builder()
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .userName(UserName.unwrap(userName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DeleteUserRequest.ReadOnly =
    zio.aws.transfer.model.DeleteUserRequest.wrap(buildAwsValue())
}
object DeleteUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DeleteUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DeleteUserRequest =
      zio.aws.transfer.model.DeleteUserRequest(serverId, userName)
    def serverId: ServerId
    def userName: UserName
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getUserName: ZIO[Any, Nothing, UserName] = ZIO.succeed(userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DeleteUserRequest
  ) extends zio.aws.transfer.model.DeleteUserRequest.ReadOnly {
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val userName: UserName =
      zio.aws.transfer.model.primitives.UserName(impl.userName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DeleteUserRequest
  ): zio.aws.transfer.model.DeleteUserRequest.ReadOnly = new Wrapper(impl)
}
