package zio.aws.transfer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeSecurityPolicyResponse(
    securityPolicy: zio.aws.transfer.model.DescribedSecurityPolicy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribeSecurityPolicyResponse = {
    import DescribeSecurityPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribeSecurityPolicyResponse
      .builder()
      .securityPolicy(securityPolicy.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.transfer.model.DescribeSecurityPolicyResponse.ReadOnly =
    zio.aws.transfer.model.DescribeSecurityPolicyResponse.wrap(buildAwsValue())
}
object DescribeSecurityPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribeSecurityPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribeSecurityPolicyResponse =
      zio.aws.transfer.model
        .DescribeSecurityPolicyResponse(securityPolicy.asEditable)
    def securityPolicy: zio.aws.transfer.model.DescribedSecurityPolicy.ReadOnly
    def getSecurityPolicy: ZIO[
      Any,
      Nothing,
      zio.aws.transfer.model.DescribedSecurityPolicy.ReadOnly
    ] = ZIO.succeed(securityPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribeSecurityPolicyResponse
  ) extends zio.aws.transfer.model.DescribeSecurityPolicyResponse.ReadOnly {
    override val securityPolicy
        : zio.aws.transfer.model.DescribedSecurityPolicy.ReadOnly =
      zio.aws.transfer.model.DescribedSecurityPolicy.wrap(impl.securityPolicy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribeSecurityPolicyResponse
  ): zio.aws.transfer.model.DescribeSecurityPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
