package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.ServerId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeUserResponse(
    serverId: ServerId,
    user: zio.aws.transfer.model.DescribedUser
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribeUserResponse = {
    import DescribeUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribeUserResponse
      .builder()
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .user(user.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribeUserResponse.ReadOnly =
    zio.aws.transfer.model.DescribeUserResponse.wrap(buildAwsValue())
}
object DescribeUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribeUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribeUserResponse =
      zio.aws.transfer.model.DescribeUserResponse(serverId, user.asEditable)
    def serverId: ServerId
    def user: zio.aws.transfer.model.DescribedUser.ReadOnly
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getUser
        : ZIO[Any, Nothing, zio.aws.transfer.model.DescribedUser.ReadOnly] =
      ZIO.succeed(user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribeUserResponse
  ) extends zio.aws.transfer.model.DescribeUserResponse.ReadOnly {
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val user: zio.aws.transfer.model.DescribedUser.ReadOnly =
      zio.aws.transfer.model.DescribedUser.wrap(impl.user())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribeUserResponse
  ): zio.aws.transfer.model.DescribeUserResponse.ReadOnly = new Wrapper(impl)
}
