package zio.aws.transfer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeWorkflowResponse(
    workflow: zio.aws.transfer.model.DescribedWorkflow
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribeWorkflowResponse = {
    import DescribeWorkflowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribeWorkflowResponse
      .builder()
      .workflow(workflow.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribeWorkflowResponse.ReadOnly =
    zio.aws.transfer.model.DescribeWorkflowResponse.wrap(buildAwsValue())
}
object DescribeWorkflowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribeWorkflowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribeWorkflowResponse =
      zio.aws.transfer.model.DescribeWorkflowResponse(workflow.asEditable)
    def workflow: zio.aws.transfer.model.DescribedWorkflow.ReadOnly
    def getWorkflow
        : ZIO[Any, Nothing, zio.aws.transfer.model.DescribedWorkflow.ReadOnly] =
      ZIO.succeed(workflow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribeWorkflowResponse
  ) extends zio.aws.transfer.model.DescribeWorkflowResponse.ReadOnly {
    override val workflow: zio.aws.transfer.model.DescribedWorkflow.ReadOnly =
      zio.aws.transfer.model.DescribedWorkflow.wrap(impl.workflow())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribeWorkflowResponse
  ): zio.aws.transfer.model.DescribeWorkflowResponse.ReadOnly = new Wrapper(
    impl
  )
}
