package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{Role, ExecutionId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribedExecution(
    executionId: Option[ExecutionId] = None,
    initialFileLocation: Option[zio.aws.transfer.model.FileLocation] = None,
    serviceMetadata: Option[zio.aws.transfer.model.ServiceMetadata] = None,
    executionRole: Option[Role] = None,
    loggingConfiguration: Option[zio.aws.transfer.model.LoggingConfiguration] =
      None,
    posixProfile: Option[zio.aws.transfer.model.PosixProfile] = None,
    status: Option[zio.aws.transfer.model.ExecutionStatus] = None,
    results: Option[zio.aws.transfer.model.ExecutionResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribedExecution = {
    import DescribedExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribedExecution
      .builder()
      .optionallyWith(
        executionId.map(value => ExecutionId.unwrap(value): java.lang.String)
      )(_.executionId)
      .optionallyWith(initialFileLocation.map(value => value.buildAwsValue()))(
        _.initialFileLocation
      )
      .optionallyWith(serviceMetadata.map(value => value.buildAwsValue()))(
        _.serviceMetadata
      )
      .optionallyWith(
        executionRole.map(value => Role.unwrap(value): java.lang.String)
      )(_.executionRole)
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .optionallyWith(posixProfile.map(value => value.buildAwsValue()))(
        _.posixProfile
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(results.map(value => value.buildAwsValue()))(_.results)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribedExecution.ReadOnly =
    zio.aws.transfer.model.DescribedExecution.wrap(buildAwsValue())
}
object DescribedExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribedExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribedExecution =
      zio.aws.transfer.model.DescribedExecution(
        executionId.map(value => value),
        initialFileLocation.map(value => value.asEditable),
        serviceMetadata.map(value => value.asEditable),
        executionRole.map(value => value),
        loggingConfiguration.map(value => value.asEditable),
        posixProfile.map(value => value.asEditable),
        status.map(value => value),
        results.map(value => value.asEditable)
      )
    def executionId: Option[ExecutionId]
    def initialFileLocation
        : Option[zio.aws.transfer.model.FileLocation.ReadOnly]
    def serviceMetadata: Option[zio.aws.transfer.model.ServiceMetadata.ReadOnly]
    def executionRole: Option[Role]
    def loggingConfiguration
        : Option[zio.aws.transfer.model.LoggingConfiguration.ReadOnly]
    def posixProfile: Option[zio.aws.transfer.model.PosixProfile.ReadOnly]
    def status: Option[zio.aws.transfer.model.ExecutionStatus]
    def results: Option[zio.aws.transfer.model.ExecutionResults.ReadOnly]
    def getExecutionId: ZIO[Any, AwsError, ExecutionId] =
      AwsError.unwrapOptionField("executionId", executionId)
    def getInitialFileLocation
        : ZIO[Any, AwsError, zio.aws.transfer.model.FileLocation.ReadOnly] =
      AwsError.unwrapOptionField("initialFileLocation", initialFileLocation)
    def getServiceMetadata
        : ZIO[Any, AwsError, zio.aws.transfer.model.ServiceMetadata.ReadOnly] =
      AwsError.unwrapOptionField("serviceMetadata", serviceMetadata)
    def getExecutionRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("executionRole", executionRole)
    def getLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.LoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
    def getPosixProfile
        : ZIO[Any, AwsError, zio.aws.transfer.model.PosixProfile.ReadOnly] =
      AwsError.unwrapOptionField("posixProfile", posixProfile)
    def getStatus: ZIO[Any, AwsError, zio.aws.transfer.model.ExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getResults
        : ZIO[Any, AwsError, zio.aws.transfer.model.ExecutionResults.ReadOnly] =
      AwsError.unwrapOptionField("results", results)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribedExecution
  ) extends zio.aws.transfer.model.DescribedExecution.ReadOnly {
    override val executionId: Option[ExecutionId] = scala
      .Option(impl.executionId())
      .map(value => zio.aws.transfer.model.primitives.ExecutionId(value))
    override val initialFileLocation
        : Option[zio.aws.transfer.model.FileLocation.ReadOnly] = scala
      .Option(impl.initialFileLocation())
      .map(value => zio.aws.transfer.model.FileLocation.wrap(value))
    override val serviceMetadata
        : Option[zio.aws.transfer.model.ServiceMetadata.ReadOnly] = scala
      .Option(impl.serviceMetadata())
      .map(value => zio.aws.transfer.model.ServiceMetadata.wrap(value))
    override val executionRole: Option[Role] = scala
      .Option(impl.executionRole())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val loggingConfiguration
        : Option[zio.aws.transfer.model.LoggingConfiguration.ReadOnly] = scala
      .Option(impl.loggingConfiguration())
      .map(value => zio.aws.transfer.model.LoggingConfiguration.wrap(value))
    override val posixProfile
        : Option[zio.aws.transfer.model.PosixProfile.ReadOnly] = scala
      .Option(impl.posixProfile())
      .map(value => zio.aws.transfer.model.PosixProfile.wrap(value))
    override val status: Option[zio.aws.transfer.model.ExecutionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.transfer.model.ExecutionStatus.wrap(value))
    override val results
        : Option[zio.aws.transfer.model.ExecutionResults.ReadOnly] = scala
      .Option(impl.results())
      .map(value => zio.aws.transfer.model.ExecutionResults.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribedExecution
  ): zio.aws.transfer.model.DescribedExecution.ReadOnly = new Wrapper(impl)
}
