package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  Certificate,
  PostAuthenticationLoginBanner,
  ServerId,
  Arn,
  PreAuthenticationLoginBanner,
  SecurityPolicyName,
  UserCount,
  HostKeyFingerprint,
  Role
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribedServer(
    arn: Arn,
    certificate: Option[Certificate] = None,
    protocolDetails: Option[zio.aws.transfer.model.ProtocolDetails] = None,
    domain: Option[zio.aws.transfer.model.Domain] = None,
    endpointDetails: Option[zio.aws.transfer.model.EndpointDetails] = None,
    endpointType: Option[zio.aws.transfer.model.EndpointType] = None,
    hostKeyFingerprint: Option[HostKeyFingerprint] = None,
    identityProviderDetails: Option[
      zio.aws.transfer.model.IdentityProviderDetails
    ] = None,
    identityProviderType: Option[zio.aws.transfer.model.IdentityProviderType] =
      None,
    loggingRole: Option[Role] = None,
    postAuthenticationLoginBanner: Option[PostAuthenticationLoginBanner] = None,
    preAuthenticationLoginBanner: Option[PreAuthenticationLoginBanner] = None,
    protocols: Option[Iterable[zio.aws.transfer.model.Protocol]] = None,
    securityPolicyName: Option[SecurityPolicyName] = None,
    serverId: Option[ServerId] = None,
    state: Option[zio.aws.transfer.model.State] = None,
    tags: Option[Iterable[zio.aws.transfer.model.Tag]] = None,
    userCount: Option[UserCount] = None,
    workflowDetails: Option[zio.aws.transfer.model.WorkflowDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribedServer = {
    import DescribedServer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribedServer
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(
        certificate.map(value => Certificate.unwrap(value): java.lang.String)
      )(_.certificate)
      .optionallyWith(protocolDetails.map(value => value.buildAwsValue()))(
        _.protocolDetails
      )
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .optionallyWith(endpointDetails.map(value => value.buildAwsValue()))(
        _.endpointDetails
      )
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(
        hostKeyFingerprint.map(value =>
          HostKeyFingerprint.unwrap(value): java.lang.String
        )
      )(_.hostKeyFingerprint)
      .optionallyWith(
        identityProviderDetails.map(value => value.buildAwsValue())
      )(_.identityProviderDetails)
      .optionallyWith(identityProviderType.map(value => value.unwrap))(
        _.identityProviderType
      )
      .optionallyWith(
        loggingRole.map(value => Role.unwrap(value): java.lang.String)
      )(_.loggingRole)
      .optionallyWith(
        postAuthenticationLoginBanner.map(value =>
          PostAuthenticationLoginBanner.unwrap(value): java.lang.String
        )
      )(_.postAuthenticationLoginBanner)
      .optionallyWith(
        preAuthenticationLoginBanner.map(value =>
          PreAuthenticationLoginBanner.unwrap(value): java.lang.String
        )
      )(_.preAuthenticationLoginBanner)
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.protocolsWithStrings)
      .optionallyWith(
        securityPolicyName.map(value =>
          SecurityPolicyName.unwrap(value): java.lang.String
        )
      )(_.securityPolicyName)
      .optionallyWith(
        serverId.map(value => ServerId.unwrap(value): java.lang.String)
      )(_.serverId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(userCount.map(value => UserCount.unwrap(value): Integer))(
        _.userCount
      )
      .optionallyWith(workflowDetails.map(value => value.buildAwsValue()))(
        _.workflowDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribedServer.ReadOnly =
    zio.aws.transfer.model.DescribedServer.wrap(buildAwsValue())
}
object DescribedServer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribedServer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribedServer =
      zio.aws.transfer.model.DescribedServer(
        arn,
        certificate.map(value => value),
        protocolDetails.map(value => value.asEditable),
        domain.map(value => value),
        endpointDetails.map(value => value.asEditable),
        endpointType.map(value => value),
        hostKeyFingerprint.map(value => value),
        identityProviderDetails.map(value => value.asEditable),
        identityProviderType.map(value => value),
        loggingRole.map(value => value),
        postAuthenticationLoginBanner.map(value => value),
        preAuthenticationLoginBanner.map(value => value),
        protocols.map(value => value),
        securityPolicyName.map(value => value),
        serverId.map(value => value),
        state.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userCount.map(value => value),
        workflowDetails.map(value => value.asEditable)
      )
    def arn: Arn
    def certificate: Option[Certificate]
    def protocolDetails: Option[zio.aws.transfer.model.ProtocolDetails.ReadOnly]
    def domain: Option[zio.aws.transfer.model.Domain]
    def endpointDetails: Option[zio.aws.transfer.model.EndpointDetails.ReadOnly]
    def endpointType: Option[zio.aws.transfer.model.EndpointType]
    def hostKeyFingerprint: Option[HostKeyFingerprint]
    def identityProviderDetails
        : Option[zio.aws.transfer.model.IdentityProviderDetails.ReadOnly]
    def identityProviderType
        : Option[zio.aws.transfer.model.IdentityProviderType]
    def loggingRole: Option[Role]
    def postAuthenticationLoginBanner: Option[PostAuthenticationLoginBanner]
    def preAuthenticationLoginBanner: Option[PreAuthenticationLoginBanner]
    def protocols: Option[List[zio.aws.transfer.model.Protocol]]
    def securityPolicyName: Option[SecurityPolicyName]
    def serverId: Option[ServerId]
    def state: Option[zio.aws.transfer.model.State]
    def tags: Option[List[zio.aws.transfer.model.Tag.ReadOnly]]
    def userCount: Option[UserCount]
    def workflowDetails: Option[zio.aws.transfer.model.WorkflowDetails.ReadOnly]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getCertificate: ZIO[Any, AwsError, Certificate] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getProtocolDetails
        : ZIO[Any, AwsError, zio.aws.transfer.model.ProtocolDetails.ReadOnly] =
      AwsError.unwrapOptionField("protocolDetails", protocolDetails)
    def getDomain: ZIO[Any, AwsError, zio.aws.transfer.model.Domain] =
      AwsError.unwrapOptionField("domain", domain)
    def getEndpointDetails
        : ZIO[Any, AwsError, zio.aws.transfer.model.EndpointDetails.ReadOnly] =
      AwsError.unwrapOptionField("endpointDetails", endpointDetails)
    def getEndpointType
        : ZIO[Any, AwsError, zio.aws.transfer.model.EndpointType] =
      AwsError.unwrapOptionField("endpointType", endpointType)
    def getHostKeyFingerprint: ZIO[Any, AwsError, HostKeyFingerprint] =
      AwsError.unwrapOptionField("hostKeyFingerprint", hostKeyFingerprint)
    def getIdentityProviderDetails: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.IdentityProviderDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "identityProviderDetails",
      identityProviderDetails
    )
    def getIdentityProviderType
        : ZIO[Any, AwsError, zio.aws.transfer.model.IdentityProviderType] =
      AwsError.unwrapOptionField("identityProviderType", identityProviderType)
    def getLoggingRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("loggingRole", loggingRole)
    def getPostAuthenticationLoginBanner
        : ZIO[Any, AwsError, PostAuthenticationLoginBanner] =
      AwsError.unwrapOptionField(
        "postAuthenticationLoginBanner",
        postAuthenticationLoginBanner
      )
    def getPreAuthenticationLoginBanner
        : ZIO[Any, AwsError, PreAuthenticationLoginBanner] =
      AwsError.unwrapOptionField(
        "preAuthenticationLoginBanner",
        preAuthenticationLoginBanner
      )
    def getProtocols
        : ZIO[Any, AwsError, List[zio.aws.transfer.model.Protocol]] =
      AwsError.unwrapOptionField("protocols", protocols)
    def getSecurityPolicyName: ZIO[Any, AwsError, SecurityPolicyName] =
      AwsError.unwrapOptionField("securityPolicyName", securityPolicyName)
    def getServerId: ZIO[Any, AwsError, ServerId] =
      AwsError.unwrapOptionField("serverId", serverId)
    def getState: ZIO[Any, AwsError, zio.aws.transfer.model.State] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, List[zio.aws.transfer.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUserCount: ZIO[Any, AwsError, UserCount] =
      AwsError.unwrapOptionField("userCount", userCount)
    def getWorkflowDetails
        : ZIO[Any, AwsError, zio.aws.transfer.model.WorkflowDetails.ReadOnly] =
      AwsError.unwrapOptionField("workflowDetails", workflowDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribedServer
  ) extends zio.aws.transfer.model.DescribedServer.ReadOnly {
    override val arn: Arn = zio.aws.transfer.model.primitives.Arn(impl.arn())
    override val certificate: Option[Certificate] = scala
      .Option(impl.certificate())
      .map(value => zio.aws.transfer.model.primitives.Certificate(value))
    override val protocolDetails
        : Option[zio.aws.transfer.model.ProtocolDetails.ReadOnly] = scala
      .Option(impl.protocolDetails())
      .map(value => zio.aws.transfer.model.ProtocolDetails.wrap(value))
    override val domain: Option[zio.aws.transfer.model.Domain] = scala
      .Option(impl.domain())
      .map(value => zio.aws.transfer.model.Domain.wrap(value))
    override val endpointDetails
        : Option[zio.aws.transfer.model.EndpointDetails.ReadOnly] = scala
      .Option(impl.endpointDetails())
      .map(value => zio.aws.transfer.model.EndpointDetails.wrap(value))
    override val endpointType: Option[zio.aws.transfer.model.EndpointType] =
      scala
        .Option(impl.endpointType())
        .map(value => zio.aws.transfer.model.EndpointType.wrap(value))
    override val hostKeyFingerprint: Option[HostKeyFingerprint] = scala
      .Option(impl.hostKeyFingerprint())
      .map(value => zio.aws.transfer.model.primitives.HostKeyFingerprint(value))
    override val identityProviderDetails
        : Option[zio.aws.transfer.model.IdentityProviderDetails.ReadOnly] =
      scala
        .Option(impl.identityProviderDetails())
        .map(value =>
          zio.aws.transfer.model.IdentityProviderDetails.wrap(value)
        )
    override val identityProviderType
        : Option[zio.aws.transfer.model.IdentityProviderType] = scala
      .Option(impl.identityProviderType())
      .map(value => zio.aws.transfer.model.IdentityProviderType.wrap(value))
    override val loggingRole: Option[Role] = scala
      .Option(impl.loggingRole())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val postAuthenticationLoginBanner
        : Option[PostAuthenticationLoginBanner] = scala
      .Option(impl.postAuthenticationLoginBanner())
      .map(value =>
        zio.aws.transfer.model.primitives.PostAuthenticationLoginBanner(value)
      )
    override val preAuthenticationLoginBanner
        : Option[PreAuthenticationLoginBanner] = scala
      .Option(impl.preAuthenticationLoginBanner())
      .map(value =>
        zio.aws.transfer.model.primitives.PreAuthenticationLoginBanner(value)
      )
    override val protocols: Option[List[zio.aws.transfer.model.Protocol]] =
      scala
        .Option(impl.protocols())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.Protocol.wrap(item)
          }.toList
        )
    override val securityPolicyName: Option[SecurityPolicyName] = scala
      .Option(impl.securityPolicyName())
      .map(value => zio.aws.transfer.model.primitives.SecurityPolicyName(value))
    override val serverId: Option[ServerId] = scala
      .Option(impl.serverId())
      .map(value => zio.aws.transfer.model.primitives.ServerId(value))
    override val state: Option[zio.aws.transfer.model.State] = scala
      .Option(impl.state())
      .map(value => zio.aws.transfer.model.State.wrap(value))
    override val tags: Option[List[zio.aws.transfer.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transfer.model.Tag.wrap(item)
        }.toList
      )
    override val userCount: Option[UserCount] = scala
      .Option(impl.userCount())
      .map(value => zio.aws.transfer.model.primitives.UserCount(value))
    override val workflowDetails
        : Option[zio.aws.transfer.model.WorkflowDetails.ReadOnly] = scala
      .Option(impl.workflowDetails())
      .map(value => zio.aws.transfer.model.WorkflowDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribedServer
  ): zio.aws.transfer.model.DescribedServer.ReadOnly = new Wrapper(impl)
}
