package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  Arn,
  HomeDirectory,
  Policy,
  Role,
  UserName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribedUser(
    arn: Arn,
    homeDirectory: Option[HomeDirectory] = None,
    homeDirectoryMappings: Option[
      Iterable[zio.aws.transfer.model.HomeDirectoryMapEntry]
    ] = None,
    homeDirectoryType: Option[zio.aws.transfer.model.HomeDirectoryType] = None,
    policy: Option[Policy] = None,
    posixProfile: Option[zio.aws.transfer.model.PosixProfile] = None,
    role: Option[Role] = None,
    sshPublicKeys: Option[Iterable[zio.aws.transfer.model.SshPublicKey]] = None,
    tags: Option[Iterable[zio.aws.transfer.model.Tag]] = None,
    userName: Option[UserName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribedUser = {
    import DescribedUser.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribedUser
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(
        homeDirectory.map(value =>
          HomeDirectory.unwrap(value): java.lang.String
        )
      )(_.homeDirectory)
      .optionallyWith(
        homeDirectoryMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.homeDirectoryMappings)
      .optionallyWith(homeDirectoryType.map(value => value.unwrap))(
        _.homeDirectoryType
      )
      .optionallyWith(
        policy.map(value => Policy.unwrap(value): java.lang.String)
      )(_.policy)
      .optionallyWith(posixProfile.map(value => value.buildAwsValue()))(
        _.posixProfile
      )
      .optionallyWith(role.map(value => Role.unwrap(value): java.lang.String))(
        _.role
      )
      .optionallyWith(
        sshPublicKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sshPublicKeys)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        userName.map(value => UserName.unwrap(value): java.lang.String)
      )(_.userName)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribedUser.ReadOnly =
    zio.aws.transfer.model.DescribedUser.wrap(buildAwsValue())
}
object DescribedUser {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribedUser
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribedUser =
      zio.aws.transfer.model.DescribedUser(
        arn,
        homeDirectory.map(value => value),
        homeDirectoryMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        homeDirectoryType.map(value => value),
        policy.map(value => value),
        posixProfile.map(value => value.asEditable),
        role.map(value => value),
        sshPublicKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userName.map(value => value)
      )
    def arn: Arn
    def homeDirectory: Option[HomeDirectory]
    def homeDirectoryMappings
        : Option[List[zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly]]
    def homeDirectoryType: Option[zio.aws.transfer.model.HomeDirectoryType]
    def policy: Option[Policy]
    def posixProfile: Option[zio.aws.transfer.model.PosixProfile.ReadOnly]
    def role: Option[Role]
    def sshPublicKeys
        : Option[List[zio.aws.transfer.model.SshPublicKey.ReadOnly]]
    def tags: Option[List[zio.aws.transfer.model.Tag.ReadOnly]]
    def userName: Option[UserName]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getHomeDirectory: ZIO[Any, AwsError, HomeDirectory] =
      AwsError.unwrapOptionField("homeDirectory", homeDirectory)
    def getHomeDirectoryMappings: ZIO[Any, AwsError, List[
      zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly
    ]] =
      AwsError.unwrapOptionField("homeDirectoryMappings", homeDirectoryMappings)
    def getHomeDirectoryType
        : ZIO[Any, AwsError, zio.aws.transfer.model.HomeDirectoryType] =
      AwsError.unwrapOptionField("homeDirectoryType", homeDirectoryType)
    def getPolicy: ZIO[Any, AwsError, Policy] =
      AwsError.unwrapOptionField("policy", policy)
    def getPosixProfile
        : ZIO[Any, AwsError, zio.aws.transfer.model.PosixProfile.ReadOnly] =
      AwsError.unwrapOptionField("posixProfile", posixProfile)
    def getRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("role", role)
    def getSshPublicKeys: ZIO[Any, AwsError, List[
      zio.aws.transfer.model.SshPublicKey.ReadOnly
    ]] = AwsError.unwrapOptionField("sshPublicKeys", sshPublicKeys)
    def getTags: ZIO[Any, AwsError, List[zio.aws.transfer.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUserName: ZIO[Any, AwsError, UserName] =
      AwsError.unwrapOptionField("userName", userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribedUser
  ) extends zio.aws.transfer.model.DescribedUser.ReadOnly {
    override val arn: Arn = zio.aws.transfer.model.primitives.Arn(impl.arn())
    override val homeDirectory: Option[HomeDirectory] = scala
      .Option(impl.homeDirectory())
      .map(value => zio.aws.transfer.model.primitives.HomeDirectory(value))
    override val homeDirectoryMappings
        : Option[List[zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly]] =
      scala
        .Option(impl.homeDirectoryMappings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.HomeDirectoryMapEntry.wrap(item)
          }.toList
        )
    override val homeDirectoryType
        : Option[zio.aws.transfer.model.HomeDirectoryType] = scala
      .Option(impl.homeDirectoryType())
      .map(value => zio.aws.transfer.model.HomeDirectoryType.wrap(value))
    override val policy: Option[Policy] = scala
      .Option(impl.policy())
      .map(value => zio.aws.transfer.model.primitives.Policy(value))
    override val posixProfile
        : Option[zio.aws.transfer.model.PosixProfile.ReadOnly] = scala
      .Option(impl.posixProfile())
      .map(value => zio.aws.transfer.model.PosixProfile.wrap(value))
    override val role: Option[Role] = scala
      .Option(impl.role())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val sshPublicKeys
        : Option[List[zio.aws.transfer.model.SshPublicKey.ReadOnly]] = scala
      .Option(impl.sshPublicKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transfer.model.SshPublicKey.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.transfer.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transfer.model.Tag.wrap(item)
        }.toList
      )
    override val userName: Option[UserName] = scala
      .Option(impl.userName())
      .map(value => zio.aws.transfer.model.primitives.UserName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribedUser
  ): zio.aws.transfer.model.DescribedUser.ReadOnly = new Wrapper(impl)
}
