package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{WorkflowId, WorkflowDescription, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribedWorkflow(
    arn: Arn,
    description: Option[WorkflowDescription] = None,
    steps: Option[Iterable[zio.aws.transfer.model.WorkflowStep]] = None,
    onExceptionSteps: Option[Iterable[zio.aws.transfer.model.WorkflowStep]] =
      None,
    workflowId: Option[WorkflowId] = None,
    tags: Option[Iterable[zio.aws.transfer.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribedWorkflow = {
    import DescribedWorkflow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribedWorkflow
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(
        description.map(value =>
          WorkflowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        steps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.steps)
      .optionallyWith(
        onExceptionSteps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.onExceptionSteps)
      .optionallyWith(
        workflowId.map(value => WorkflowId.unwrap(value): java.lang.String)
      )(_.workflowId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribedWorkflow.ReadOnly =
    zio.aws.transfer.model.DescribedWorkflow.wrap(buildAwsValue())
}
object DescribedWorkflow {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribedWorkflow
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribedWorkflow =
      zio.aws.transfer.model.DescribedWorkflow(
        arn,
        description.map(value => value),
        steps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        onExceptionSteps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        workflowId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Arn
    def description: Option[WorkflowDescription]
    def steps: Option[List[zio.aws.transfer.model.WorkflowStep.ReadOnly]]
    def onExceptionSteps
        : Option[List[zio.aws.transfer.model.WorkflowStep.ReadOnly]]
    def workflowId: Option[WorkflowId]
    def tags: Option[List[zio.aws.transfer.model.Tag.ReadOnly]]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getDescription: ZIO[Any, AwsError, WorkflowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSteps: ZIO[Any, AwsError, List[
      zio.aws.transfer.model.WorkflowStep.ReadOnly
    ]] = AwsError.unwrapOptionField("steps", steps)
    def getOnExceptionSteps: ZIO[Any, AwsError, List[
      zio.aws.transfer.model.WorkflowStep.ReadOnly
    ]] = AwsError.unwrapOptionField("onExceptionSteps", onExceptionSteps)
    def getWorkflowId: ZIO[Any, AwsError, WorkflowId] =
      AwsError.unwrapOptionField("workflowId", workflowId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.transfer.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribedWorkflow
  ) extends zio.aws.transfer.model.DescribedWorkflow.ReadOnly {
    override val arn: Arn = zio.aws.transfer.model.primitives.Arn(impl.arn())
    override val description: Option[WorkflowDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.transfer.model.primitives.WorkflowDescription(value)
      )
    override val steps
        : Option[List[zio.aws.transfer.model.WorkflowStep.ReadOnly]] = scala
      .Option(impl.steps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transfer.model.WorkflowStep.wrap(item)
        }.toList
      )
    override val onExceptionSteps
        : Option[List[zio.aws.transfer.model.WorkflowStep.ReadOnly]] = scala
      .Option(impl.onExceptionSteps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transfer.model.WorkflowStep.wrap(item)
        }.toList
      )
    override val workflowId: Option[WorkflowId] = scala
      .Option(impl.workflowId())
      .map(value => zio.aws.transfer.model.primitives.WorkflowId(value))
    override val tags: Option[List[zio.aws.transfer.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transfer.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribedWorkflow
  ): zio.aws.transfer.model.DescribedWorkflow.ReadOnly = new Wrapper(impl)
}
