package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait Domain {
  def unwrap: software.amazon.awssdk.services.transfer.model.Domain
}
object Domain {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.Domain
  ): zio.aws.transfer.model.Domain = value match {
    case software.amazon.awssdk.services.transfer.model.Domain.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.Domain.S3 =>
      val r = S3
      r
    case software.amazon.awssdk.services.transfer.model.Domain.EFS =>
      val r = EFS
      r
  }
  case object unknownToSdkVersion extends zio.aws.transfer.model.Domain {
    override def unwrap: software.amazon.awssdk.services.transfer.model.Domain =
      software.amazon.awssdk.services.transfer.model.Domain.UNKNOWN_TO_SDK_VERSION
  }
  case object S3 extends zio.aws.transfer.model.Domain {
    override def unwrap: software.amazon.awssdk.services.transfer.model.Domain =
      software.amazon.awssdk.services.transfer.model.Domain.S3
  }
  case object EFS extends zio.aws.transfer.model.Domain {
    override def unwrap: software.amazon.awssdk.services.transfer.model.Domain =
      software.amazon.awssdk.services.transfer.model.Domain.EFS
  }
}
