package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{EfsPath, EfsFileSystemId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EfsFileLocation(
    fileSystemId: Option[EfsFileSystemId] = None,
    path: Option[EfsPath] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.EfsFileLocation = {
    import EfsFileLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.EfsFileLocation
      .builder()
      .optionallyWith(
        fileSystemId.map(value =>
          EfsFileSystemId.unwrap(value): java.lang.String
        )
      )(_.fileSystemId)
      .optionallyWith(
        path.map(value => EfsPath.unwrap(value): java.lang.String)
      )(_.path)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.EfsFileLocation.ReadOnly =
    zio.aws.transfer.model.EfsFileLocation.wrap(buildAwsValue())
}
object EfsFileLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.EfsFileLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.EfsFileLocation =
      zio.aws.transfer.model.EfsFileLocation(
        fileSystemId.map(value => value),
        path.map(value => value)
      )
    def fileSystemId: Option[EfsFileSystemId]
    def path: Option[EfsPath]
    def getFileSystemId: ZIO[Any, AwsError, EfsFileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getPath: ZIO[Any, AwsError, EfsPath] =
      AwsError.unwrapOptionField("path", path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.EfsFileLocation
  ) extends zio.aws.transfer.model.EfsFileLocation.ReadOnly {
    override val fileSystemId: Option[EfsFileSystemId] = scala
      .Option(impl.fileSystemId())
      .map(value => zio.aws.transfer.model.primitives.EfsFileSystemId(value))
    override val path: Option[EfsPath] = scala
      .Option(impl.path())
      .map(value => zio.aws.transfer.model.primitives.EfsPath(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.EfsFileLocation
  ): zio.aws.transfer.model.EfsFileLocation.ReadOnly = new Wrapper(impl)
}
