package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  SubnetId,
  VpcId,
  SecurityGroupId,
  AddressAllocationId,
  VpcEndpointId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EndpointDetails(
    addressAllocationIds: Option[Iterable[AddressAllocationId]] = None,
    subnetIds: Option[Iterable[SubnetId]] = None,
    vpcEndpointId: Option[VpcEndpointId] = None,
    vpcId: Option[VpcId] = None,
    securityGroupIds: Option[Iterable[SecurityGroupId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.EndpointDetails = {
    import EndpointDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.EndpointDetails
      .builder()
      .optionallyWith(
        addressAllocationIds.map(value =>
          value.map { item =>
            AddressAllocationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.addressAllocationIds)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        vpcEndpointId.map(value =>
          VpcEndpointId.unwrap(value): java.lang.String
        )
      )(_.vpcEndpointId)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.EndpointDetails.ReadOnly =
    zio.aws.transfer.model.EndpointDetails.wrap(buildAwsValue())
}
object EndpointDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.EndpointDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.EndpointDetails =
      zio.aws.transfer.model.EndpointDetails(
        addressAllocationIds.map(value => value),
        subnetIds.map(value => value),
        vpcEndpointId.map(value => value),
        vpcId.map(value => value),
        securityGroupIds.map(value => value)
      )
    def addressAllocationIds: Option[List[AddressAllocationId]]
    def subnetIds: Option[List[SubnetId]]
    def vpcEndpointId: Option[VpcEndpointId]
    def vpcId: Option[VpcId]
    def securityGroupIds: Option[List[SecurityGroupId]]
    def getAddressAllocationIds: ZIO[Any, AwsError, List[AddressAllocationId]] =
      AwsError.unwrapOptionField("addressAllocationIds", addressAllocationIds)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getVpcEndpointId: ZIO[Any, AwsError, VpcEndpointId] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.EndpointDetails
  ) extends zio.aws.transfer.model.EndpointDetails.ReadOnly {
    override val addressAllocationIds: Option[List[AddressAllocationId]] = scala
      .Option(impl.addressAllocationIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transfer.model.primitives.AddressAllocationId(item)
        }.toList
      )
    override val subnetIds: Option[List[SubnetId]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transfer.model.primitives.SubnetId(item)
        }.toList
      )
    override val vpcEndpointId: Option[VpcEndpointId] = scala
      .Option(impl.vpcEndpointId())
      .map(value => zio.aws.transfer.model.primitives.VpcEndpointId(value))
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.transfer.model.primitives.VpcId(value))
    override val securityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transfer.model.primitives.SecurityGroupId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.EndpointDetails
  ): zio.aws.transfer.model.EndpointDetails.ReadOnly = new Wrapper(impl)
}
