package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.ExecutionErrorMessage
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ExecutionError(
    `type`: zio.aws.transfer.model.ExecutionErrorType,
    message: ExecutionErrorMessage
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ExecutionError = {
    import ExecutionError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ExecutionError
      .builder()
      .`type`(`type`.unwrap)
      .message(ExecutionErrorMessage.unwrap(message): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ExecutionError.ReadOnly =
    zio.aws.transfer.model.ExecutionError.wrap(buildAwsValue())
}
object ExecutionError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ExecutionError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ExecutionError =
      zio.aws.transfer.model.ExecutionError(`type`, message)
    def `type`: zio.aws.transfer.model.ExecutionErrorType
    def message: ExecutionErrorMessage
    def getType: ZIO[Any, Nothing, zio.aws.transfer.model.ExecutionErrorType] =
      ZIO.succeed(`type`)
    def getMessage: ZIO[Any, Nothing, ExecutionErrorMessage] =
      ZIO.succeed(message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ExecutionError
  ) extends zio.aws.transfer.model.ExecutionError.ReadOnly {
    override val `type`: zio.aws.transfer.model.ExecutionErrorType =
      zio.aws.transfer.model.ExecutionErrorType.wrap(impl.`type`())
    override val message: ExecutionErrorMessage =
      zio.aws.transfer.model.primitives.ExecutionErrorMessage(impl.message())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ExecutionError
  ): zio.aws.transfer.model.ExecutionError.ReadOnly = new Wrapper(impl)
}
