package zio.aws.transfer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExecutionResults(
    steps: Option[Iterable[zio.aws.transfer.model.ExecutionStepResult]] = None,
    onExceptionSteps: Option[
      Iterable[zio.aws.transfer.model.ExecutionStepResult]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ExecutionResults = {
    import ExecutionResults.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ExecutionResults
      .builder()
      .optionallyWith(
        steps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.steps)
      .optionallyWith(
        onExceptionSteps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.onExceptionSteps)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ExecutionResults.ReadOnly =
    zio.aws.transfer.model.ExecutionResults.wrap(buildAwsValue())
}
object ExecutionResults {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ExecutionResults
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ExecutionResults =
      zio.aws.transfer.model.ExecutionResults(
        steps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        onExceptionSteps.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def steps: Option[List[zio.aws.transfer.model.ExecutionStepResult.ReadOnly]]
    def onExceptionSteps
        : Option[List[zio.aws.transfer.model.ExecutionStepResult.ReadOnly]]
    def getSteps: ZIO[Any, AwsError, List[
      zio.aws.transfer.model.ExecutionStepResult.ReadOnly
    ]] = AwsError.unwrapOptionField("steps", steps)
    def getOnExceptionSteps: ZIO[Any, AwsError, List[
      zio.aws.transfer.model.ExecutionStepResult.ReadOnly
    ]] = AwsError.unwrapOptionField("onExceptionSteps", onExceptionSteps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ExecutionResults
  ) extends zio.aws.transfer.model.ExecutionResults.ReadOnly {
    override val steps
        : Option[List[zio.aws.transfer.model.ExecutionStepResult.ReadOnly]] =
      scala
        .Option(impl.steps())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.ExecutionStepResult.wrap(item)
          }.toList
        )
    override val onExceptionSteps
        : Option[List[zio.aws.transfer.model.ExecutionStepResult.ReadOnly]] =
      scala
        .Option(impl.onExceptionSteps())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.ExecutionStepResult.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ExecutionResults
  ): zio.aws.transfer.model.ExecutionResults.ReadOnly = new Wrapper(impl)
}
