package zio.aws.transfer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FileLocation(
    s3FileLocation: Option[zio.aws.transfer.model.S3FileLocation] = None,
    efsFileLocation: Option[zio.aws.transfer.model.EfsFileLocation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.FileLocation = {
    import FileLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.FileLocation
      .builder()
      .optionallyWith(s3FileLocation.map(value => value.buildAwsValue()))(
        _.s3FileLocation
      )
      .optionallyWith(efsFileLocation.map(value => value.buildAwsValue()))(
        _.efsFileLocation
      )
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.FileLocation.ReadOnly =
    zio.aws.transfer.model.FileLocation.wrap(buildAwsValue())
}
object FileLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.FileLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.FileLocation =
      zio.aws.transfer.model.FileLocation(
        s3FileLocation.map(value => value.asEditable),
        efsFileLocation.map(value => value.asEditable)
      )
    def s3FileLocation: Option[zio.aws.transfer.model.S3FileLocation.ReadOnly]
    def efsFileLocation: Option[zio.aws.transfer.model.EfsFileLocation.ReadOnly]
    def getS3FileLocation
        : ZIO[Any, AwsError, zio.aws.transfer.model.S3FileLocation.ReadOnly] =
      AwsError.unwrapOptionField("s3FileLocation", s3FileLocation)
    def getEfsFileLocation
        : ZIO[Any, AwsError, zio.aws.transfer.model.EfsFileLocation.ReadOnly] =
      AwsError.unwrapOptionField("efsFileLocation", efsFileLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.FileLocation
  ) extends zio.aws.transfer.model.FileLocation.ReadOnly {
    override val s3FileLocation
        : Option[zio.aws.transfer.model.S3FileLocation.ReadOnly] = scala
      .Option(impl.s3FileLocation())
      .map(value => zio.aws.transfer.model.S3FileLocation.wrap(value))
    override val efsFileLocation
        : Option[zio.aws.transfer.model.EfsFileLocation.ReadOnly] = scala
      .Option(impl.efsFileLocation())
      .map(value => zio.aws.transfer.model.EfsFileLocation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.FileLocation
  ): zio.aws.transfer.model.FileLocation.ReadOnly = new Wrapper(impl)
}
