package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{DirectoryId, Role, Url}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IdentityProviderDetails(
    url: Option[Url] = None,
    invocationRole: Option[Role] = None,
    directoryId: Option[DirectoryId] = None,
    function: Option[zio.aws.transfer.model.primitives.Function] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.IdentityProviderDetails = {
    import IdentityProviderDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.IdentityProviderDetails
      .builder()
      .optionallyWith(url.map(value => Url.unwrap(value): java.lang.String))(
        _.url
      )
      .optionallyWith(
        invocationRole.map(value => Role.unwrap(value): java.lang.String)
      )(_.invocationRole)
      .optionallyWith(
        directoryId.map(value => DirectoryId.unwrap(value): java.lang.String)
      )(_.directoryId)
      .optionallyWith(
        function.map(value =>
          zio.aws.transfer.model.primitives.Function
            .unwrap(value): java.lang.String
        )
      )(_.function)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.IdentityProviderDetails.ReadOnly =
    zio.aws.transfer.model.IdentityProviderDetails.wrap(buildAwsValue())
}
object IdentityProviderDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.IdentityProviderDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.IdentityProviderDetails =
      zio.aws.transfer.model.IdentityProviderDetails(
        url.map(value => value),
        invocationRole.map(value => value),
        directoryId.map(value => value),
        function.map(value => value)
      )
    def url: Option[Url]
    def invocationRole: Option[Role]
    def directoryId: Option[DirectoryId]
    def function: Option[zio.aws.transfer.model.primitives.Function]
    def getUrl: ZIO[Any, AwsError, Url] = AwsError.unwrapOptionField("url", url)
    def getInvocationRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("invocationRole", invocationRole)
    def getDirectoryId: ZIO[Any, AwsError, DirectoryId] =
      AwsError.unwrapOptionField("directoryId", directoryId)
    def getFunction
        : ZIO[Any, AwsError, zio.aws.transfer.model.primitives.Function] =
      AwsError.unwrapOptionField("function", function)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.IdentityProviderDetails
  ) extends zio.aws.transfer.model.IdentityProviderDetails.ReadOnly {
    override val url: Option[Url] = scala
      .Option(impl.url())
      .map(value => zio.aws.transfer.model.primitives.Url(value))
    override val invocationRole: Option[Role] = scala
      .Option(impl.invocationRole())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val directoryId: Option[DirectoryId] = scala
      .Option(impl.directoryId())
      .map(value => zio.aws.transfer.model.primitives.DirectoryId(value))
    override val function: Option[zio.aws.transfer.model.primitives.Function] =
      scala
        .Option(impl.function())
        .map(value => zio.aws.transfer.model.primitives.Function(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.IdentityProviderDetails
  ): zio.aws.transfer.model.IdentityProviderDetails.ReadOnly = new Wrapper(impl)
}
