package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait IdentityProviderType {
  def unwrap
      : software.amazon.awssdk.services.transfer.model.IdentityProviderType
}
object IdentityProviderType {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.IdentityProviderType
  ): zio.aws.transfer.model.IdentityProviderType = value match {
    case software.amazon.awssdk.services.transfer.model.IdentityProviderType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.IdentityProviderType.SERVICE_MANAGED =>
      val r = SERVICE_MANAGED
      r
    case software.amazon.awssdk.services.transfer.model.IdentityProviderType.API_GATEWAY =>
      val r = API_GATEWAY
      r
    case software.amazon.awssdk.services.transfer.model.IdentityProviderType.AWS_DIRECTORY_SERVICE =>
      val r = AWS_DIRECTORY_SERVICE
      r
    case software.amazon.awssdk.services.transfer.model.IdentityProviderType.AWS_LAMBDA =>
      val r = AWS_LAMBDA
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transfer.model.IdentityProviderType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.IdentityProviderType =
      software.amazon.awssdk.services.transfer.model.IdentityProviderType.UNKNOWN_TO_SDK_VERSION
  }
  case object SERVICE_MANAGED
      extends zio.aws.transfer.model.IdentityProviderType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.IdentityProviderType =
      software.amazon.awssdk.services.transfer.model.IdentityProviderType.SERVICE_MANAGED
  }
  case object API_GATEWAY extends zio.aws.transfer.model.IdentityProviderType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.IdentityProviderType =
      software.amazon.awssdk.services.transfer.model.IdentityProviderType.API_GATEWAY
  }
  case object AWS_DIRECTORY_SERVICE
      extends zio.aws.transfer.model.IdentityProviderType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.IdentityProviderType =
      software.amazon.awssdk.services.transfer.model.IdentityProviderType.AWS_DIRECTORY_SERVICE
  }
  case object AWS_LAMBDA extends zio.aws.transfer.model.IdentityProviderType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.IdentityProviderType =
      software.amazon.awssdk.services.transfer.model.IdentityProviderType.AWS_LAMBDA
  }
}
