package zio.aws.transfer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InputFileLocation(
    s3FileLocation: Option[zio.aws.transfer.model.S3InputFileLocation] = None,
    efsFileLocation: Option[zio.aws.transfer.model.EfsFileLocation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.InputFileLocation = {
    import InputFileLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.InputFileLocation
      .builder()
      .optionallyWith(s3FileLocation.map(value => value.buildAwsValue()))(
        _.s3FileLocation
      )
      .optionallyWith(efsFileLocation.map(value => value.buildAwsValue()))(
        _.efsFileLocation
      )
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.InputFileLocation.ReadOnly =
    zio.aws.transfer.model.InputFileLocation.wrap(buildAwsValue())
}
object InputFileLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.InputFileLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.InputFileLocation =
      zio.aws.transfer.model.InputFileLocation(
        s3FileLocation.map(value => value.asEditable),
        efsFileLocation.map(value => value.asEditable)
      )
    def s3FileLocation
        : Option[zio.aws.transfer.model.S3InputFileLocation.ReadOnly]
    def efsFileLocation: Option[zio.aws.transfer.model.EfsFileLocation.ReadOnly]
    def getS3FileLocation: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.S3InputFileLocation.ReadOnly
    ] = AwsError.unwrapOptionField("s3FileLocation", s3FileLocation)
    def getEfsFileLocation
        : ZIO[Any, AwsError, zio.aws.transfer.model.EfsFileLocation.ReadOnly] =
      AwsError.unwrapOptionField("efsFileLocation", efsFileLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.InputFileLocation
  ) extends zio.aws.transfer.model.InputFileLocation.ReadOnly {
    override val s3FileLocation
        : Option[zio.aws.transfer.model.S3InputFileLocation.ReadOnly] = scala
      .Option(impl.s3FileLocation())
      .map(value => zio.aws.transfer.model.S3InputFileLocation.wrap(value))
    override val efsFileLocation
        : Option[zio.aws.transfer.model.EfsFileLocation.ReadOnly] = scala
      .Option(impl.efsFileLocation())
      .map(value => zio.aws.transfer.model.EfsFileLocation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.InputFileLocation
  ): zio.aws.transfer.model.InputFileLocation.ReadOnly = new Wrapper(impl)
}
